/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.enchantment.liquefier;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.binder.BinderBlock;
import sirttas.elementalcraft.block.instrument.enchantment.liquefier.EnchantmentLiquefierBlockEntity;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.container.ECContainerHelper;

public class EnchantmentLiquefierBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "enchantment_liquefier";
    public static final MapCodec<EnchantmentLiquefierBlock> CODEC = EnchantmentLiquefierBlock.simpleCodec(EnchantmentLiquefierBlock::new);
    private static final VoxelShape SLAB = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape SLAB_2 = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final VoxelShape PILLAR_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape PILLAR_2 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape PILLAR_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape PILLAR_4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_LOWER = Shapes.or((VoxelShape)SLAB, (VoxelShape[])new VoxelShape[]{SLAB_2, CONNECTION, PILLAR_1, PILLAR_2, PILLAR_3, PILLAR_4});
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public EnchantmentLiquefierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<EnchantmentLiquefierBlock> codec() {
        return CODEC;
    }

    protected boolean isLower(BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!this.isLower(state)) {
            pos = pos.below();
        }
        EnchantmentLiquefierBlockEntity enchantmentLiquefier = (EnchantmentLiquefierBlockEntity)level.getBlockEntity(pos);
        ItemStack heldItem = player.getItemInHand(hand);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        if (enchantmentLiquefier != null && hand == InteractionHand.MAIN_HAND) {
            if ((enchantmentLiquefier.isLocked() || heldItem.isEmpty() || player.isShiftKeyDown()) && !enchantmentLiquefier.getInventory().isEmpty()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.EMPTY, i);
                }
                return ItemInteractionResult.SUCCESS;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).isEmpty() || this.onSlotActivated(inv, player, heldItem, i) != ItemInteractionResult.SUCCESS) continue;
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.isLower(state) ? new EnchantmentLiquefierBlockEntity(pos, state) : null;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.isLower(state) ? this.createInstrumentTicker(level, type, ECBlockEntityTypes.ENCHANTMENT_LIQUEFIER) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        AbstractPylonShrineBlock.doubleHalfHarvest(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return AbstractPylonShrineBlock.doubleHalfUpdateShape(state, facing, facingState, level, pos, () -> {
            WaterLoggingHelper.scheduleWaterTick(state, level, pos);
            return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
        });
    }

    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        if (!AbstractPylonShrineBlock.canReplaceAboveBlock(context)) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, HALF});
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return this.isLower(state) && ElementContainer.isValidContainer(state, level, below) || level.getBlockState(below).is((Block)this);
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.isLower(state) ? SHAPE_LOWER : BinderBlock.SHAPE;
    }
}

