/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class CrystallizerRenderer
implements BlockEntityRenderer<CrystallizerBlockEntity> {
    public void render(CrystallizerBlockEntity te, float partialTicks, PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        float tick = ECRendererHelper.getClientTicks(partialTicks);
        InstrumentContainer inv = (InstrumentContainer)te.getInventory();
        matrixStack.translate(0.0f, 0.25f, 0.0f);
        ECRendererHelper.renderRunes(matrixStack, buffer, te.getRuneHandler(), tick, light, overlay);
        matrixStack.translate(0.5f, 0.15f, 0.5f);
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        this.renderGem(matrixStack, buffer, light, overlay, tick, inv.getItem(0));
        this.renderCrystal(matrixStack, buffer, light, overlay, tick, inv.getItem(1));
    }

    private void renderGem(PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, float tick, ItemStack stack) {
        if (!stack.isEmpty()) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f, -0.15f, 0.0f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(tick));
            ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
            matrixStack.popPose();
        }
    }

    private void renderCrystal(PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, float tick, ItemStack stack) {
        if (!stack.isEmpty()) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.9f, 0.0f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-tick));
            ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
            matrixStack.popPose();
        }
    }
}

