/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;

public class CrystallizerContainer
extends InstrumentContainer {
    private static final List<Ingredient> FIRST_SLOT_ITEMS = new ArrayList<Ingredient>();
    private static final List<Ingredient> SECOND_SLOT_ITEMS = new ArrayList<Ingredient>();

    public CrystallizerContainer(CrystallizerBlockEntity crystallizer) {
        super(crystallizer::setChanged, 2);
    }

    public boolean canPlaceItem(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return FIRST_SLOT_ITEMS.isEmpty() || FIRST_SLOT_ITEMS.stream().anyMatch(i -> i.test(stack));
        }
        if (slot == 1) {
            return SECOND_SLOT_ITEMS.isEmpty() || SECOND_SLOT_ITEMS.stream().anyMatch(i -> i.test(stack));
        }
        return false;
    }

    public static void reload(RecipeManager recipeManager) {
        List recipes = recipeManager.getAllRecipesFor((RecipeType)ECRecipeTypes.CRYSTALLIZATION.get());
        FIRST_SLOT_ITEMS.clear();
        SECOND_SLOT_ITEMS.clear();
        for (RecipeHolder holder : recipes) {
            CrystallizationRecipe recipe = (CrystallizationRecipe)holder.value();
            NonNullList<Ingredient> ingredients = recipe.getIngredients();
            if (!ingredients.isEmpty()) {
                FIRST_SLOT_ITEMS.add((Ingredient)ingredients.getFirst());
            }
            if (ingredients.size() <= 1) continue;
            SECOND_SLOT_ITEMS.add((Ingredient)ingredients.get(1));
        }
    }
}

