/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;

public class CrystallizerBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "crystallizer";
    public static final MapCodec<CrystallizerBlock> CODEC = CrystallizerBlock.simpleCodec(CrystallizerBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_PIPE_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_2 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_PIPE_4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0);
    private static final VoxelShape TOP_1 = Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape TOP_2 = Block.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final VoxelShape HOLE_1 = Block.box((double)6.0, (double)3.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0);
    private static final VoxelShape HOLE_2 = Block.box((double)4.0, (double)3.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0);
    private static final VoxelShape TOP = Shapes.join((VoxelShape)Shapes.or((VoxelShape)TOP_1, (VoxelShape)TOP_2), (VoxelShape)Shapes.or((VoxelShape)HOLE_1, (VoxelShape)HOLE_2), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{CONNECTION, BASE_PIPE_1, BASE_PIPE_2, BASE_PIPE_3, BASE_PIPE_4, TOP});

    public CrystallizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<CrystallizerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new CrystallizerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, ECBlockEntityTypes.CRYSTALLIZER);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        CrystallizerBlockEntity crystallizer = (CrystallizerBlockEntity)level.getBlockEntity(pos);
        ItemStack heldItem = player.getItemInHand(hand);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        if (crystallizer != null && hand == InteractionHand.MAIN_HAND) {
            if ((crystallizer.isLocked() || heldItem.isEmpty() || player.isShiftKeyDown()) && !crystallizer.getInventory().isEmpty()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.EMPTY, i);
                }
                return ItemInteractionResult.SUCCESS;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).isEmpty() || this.onSlotActivated(inv, player, heldItem, i) != ItemInteractionResult.SUCCESS) continue;
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }
}

