/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.binder;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.binder.IBinder;
import sirttas.elementalcraft.recipe.input.MultipleItemsSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;

public class BinderBlockEntity
extends AbstractInstrumentBlockEntity<MultipleItemsSingleElementRecipeInput, AbstractBindingRecipe>
implements IBinder {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("binder");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final InstrumentContainer inventory = new InstrumentContainer(this::setChanged, 20);

    public BinderBlockEntity(BlockPos pos, BlockState state) {
        this((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.BINDER, PROPERTIES, pos, state);
    }

    protected BinderBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, BlockPos pos, BlockState state) {
        super(blockEntityType, properties, pos, state);
        this.particleOffset = new Vec3(0.0, 0.2, 0.0);
    }

    @Override
    public int getItemCount() {
        return this.inventory.getItemCount();
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    protected void assemble() {
        ItemStack remainingItem = (ItemStack)((AbstractBindingRecipe)this.recipe).getRemainingItems(this.createRecipeInput()).getFirst();
        super.assemble();
        if (!remainingItem.isEmpty()) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                if (!this.inventory.getItem(i).isEmpty()) continue;
                this.inventory.setItem(i, remainingItem);
                break;
            }
        }
    }

    @Override
    protected void setRemainingItems(NonNullList<ItemStack> remainingItems) {
        int targetIndex = 1;
        for (ItemStack stack : remainingItems) {
            if (targetIndex >= 20) {
                return;
            }
            if (stack.isEmpty()) continue;
            this.inventory.setItem(targetIndex++, stack);
        }
    }

    @Override
    @NotNull
    protected MultipleItemsSingleElementRecipeInput createRecipeInput() {
        return new MultipleItemsSingleElementRecipeInput(this.inventory.getStacks(), this.getElementType(), this.getContainer().getElementAmount());
    }
}

