/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.binder;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.binder.BinderBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;

public class BinderBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "binder";
    public static final MapCodec<BinderBlock> CODEC = BinderBlock.simpleCodec(BinderBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape BASE_2 = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    private static final VoxelShape PIPE_1 = Block.box((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)7.0, (double)3.0);
    private static final VoxelShape PIPE_2 = Block.box((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)3.0);
    private static final VoxelShape PIPE_3 = Block.box((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)7.0, (double)15.0);
    private static final VoxelShape PIPE_4 = Block.box((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)7.0, (double)15.0);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PIPE_1, PIPE_2, PIPE_3, PIPE_4});

    public BinderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BinderBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new BinderBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, ECBlockEntityTypes.BINDER);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BinderBlockEntity binder = (BinderBlockEntity)level.getBlockEntity(pos);
        ItemStack heldItem = player.getItemInHand(hand);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        if (binder != null && hand == InteractionHand.MAIN_HAND) {
            if ((binder.isLocked() || heldItem.isEmpty() || player.isShiftKeyDown()) && !binder.getInventory().isEmpty()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.EMPTY, i);
                }
                return ItemInteractionResult.SUCCESS;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).isEmpty()) continue;
                return this.onSlotActivated(inv, player, heldItem, i);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, @Nonnull LevelReader world, BlockPos pos) {
        return ElementContainer.isValidContainer(state, world, pos.below());
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }
}

