/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sirttas.elementalcraft.container.AbstractSynchronizableContainer;

public class InstrumentContainer
extends AbstractSynchronizableContainer
implements INBTSerializable<CompoundTag> {
    private final NonNullList<ItemStack> stacks;
    private final int size;

    public InstrumentContainer(int size) {
        this(null, size);
    }

    public InstrumentContainer(Runnable syncCallback, int size) {
        super(syncCallback);
        this.size = size;
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return this.size;
    }

    public int getItemCount() {
        return (int)this.stacks.stream().filter(i -> !i.isEmpty()).count();
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty() || this.stacks.stream().allMatch(ItemStack::isEmpty);
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return this.stacks.size() > index ? (ItemStack)this.stacks.get(index) : ItemStack.EMPTY;
    }

    public void setItem(int index, @Nonnull ItemStack stack) {
        if (index < this.stacks.size()) {
            this.stacks.set(index, (Object)stack);
        } else if (stack.isEmpty()) {
            this.stacks.add((Object)stack);
        }
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void clearContent() {
        this.stacks.clear();
    }

    @Nonnull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.stacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack ret = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return ret;
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.stacks, (HolderLookup.Provider)provider);
        return nbt;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, CompoundTag nbt) {
        this.clearContent();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.stacks, (HolderLookup.Provider)provider);
    }
}

