/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.entity.crafting.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.IInstrument;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public abstract class AbstractInstrumentBlockEntity<I extends RecipeInput, R extends IInstrumentRecipe<I>>
extends AbstractECCraftingBlockEntity<I, R>
implements IInstrument {
    private int progress = 0;
    private ISingleElementStorage containerCache;
    protected Vec3 particleOffset = Vec3.ZERO;

    protected AbstractInstrumentBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, BlockPos pos, BlockState state) {
        super(blockEntityType, properties, pos, state);
    }

    @Override
    public void process() {
        super.process();
        if (this.level.isClientSide) {
            ParticleHelper.createCraftingParticle(this.getElementType(), this.level, Vec3.atCenterOf((Vec3i)this.worldPosition).add(this.particleOffset), this.level.random);
        }
    }

    public static <I extends RecipeInput, R extends IInstrumentRecipe<I>> void tick(Level level, BlockPos pos, BlockState state, AbstractInstrumentBlockEntity<I, R> instrument) {
        if (!instrument.isPowered() && instrument.progressOnTick()) {
            instrument.makeProgress();
        }
        AbstractECCraftingBlockEntity.tick(instrument);
    }

    protected boolean progressOnTick() {
        return true;
    }

    protected boolean makeProgress() {
        int recipeCost;
        ISingleElementStorage container = this.getContainer();
        int n = recipeCost = this.recipe == null ? 0 : ((IInstrumentRecipe)this.recipe).getElementAmount(this.createRecipeInput());
        if (this.recipe != null && this.progress >= recipeCost) {
            this.process();
            this.progress = 0;
            return true;
        }
        if (this.isRecipeAvailable() && container != null) {
            float preservation = this.runeHandler.getElementPreservation();
            int oldProgress = this.progress;
            int transfer = this.ceilTransfer(container, Math.round(this.runeHandler.getTransferSpeed(this.getTransferSpeed()) / preservation), recipeCost);
            this.progress += Math.round((float)container.extractElement(transfer, this.getRecipeElementType(), false) * preservation);
            if (this.level.isClientSide && this.progress > 0 && this.getProgressRounded(transfer, this.progress) > this.getProgressRounded(transfer, oldProgress)) {
                ParticleHelper.createElementFlowParticle(this.getElementType(), this.level, Vec3.atCenterOf((Vec3i)this.worldPosition).add(this.particleOffset), Direction.UP, 1.0f, this.level.random);
                this.renderProgressParticles();
            }
            return true;
        }
        if (this.recipe == null) {
            this.progress = 0;
        }
        return false;
    }

    private int ceilTransfer(ISingleElementStorage container, int transfer, int recipeCost) {
        int max = container.getElementAmount();
        if (max <= 0) {
            return 0;
        }
        if (transfer >= max) {
            transfer = this.progress + max < recipeCost ? max - 1 : max;
        }
        return Math.max(0, transfer);
    }

    protected void renderProgressParticles() {
    }

    protected ElementType getRecipeElementType() {
        Recipe recipe = this.recipe;
        if (recipe instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)recipe;
            return provider.getElementType();
        }
        return ElementType.NONE;
    }

    @Override
    protected void assemble() {
        Object input = this.createRecipeInput();
        NonNullList remainingItems = ((IInstrumentRecipe)this.recipe).getRemainingItems((RecipeInput)input);
        this.getInventory().setItem(this.getOutputSlot(), ((IInstrumentRecipe)this.recipe).assemble(input, (HolderLookup.Provider)this.level.registryAccess()));
        this.setRemainingItems((NonNullList<ItemStack>)remainingItems);
    }

    protected void setRemainingItems(NonNullList<ItemStack> remainingItems) {
        Container inv = this.getInventory();
        int size = inv.getContainerSize();
        int outputSlot = this.getOutputSlot();
        for (int i = 0; i < size; ++i) {
            if (i == outputSlot) continue;
            inv.setItem(i, (ItemStack)remainingItems.get(i));
        }
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        ElementType containerType = this.getContainerElementType();
        return containerType != ElementType.NONE || this.recipe == null ? containerType : this.getRecipeElementType();
    }

    @Override
    public boolean isRunning() {
        return this.progress > 0;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("progress", this.progress);
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.progress = compound.getInt("progress");
    }

    @Override
    public void clearContent() {
        super.clearContent();
        this.progress = 0;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IInstrument.super.getContainer();
        }
        return this.containerCache;
    }

    @Override
    protected R lookupRecipe(@NotNull I recipeInput) {
        if (this.getContainerElementType() == ElementType.NONE) {
            return null;
        }
        return (R)((IInstrumentRecipe)super.lookupRecipe(recipeInput));
    }
}

