/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.extractor;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.block.source.SourceElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleStackContainer;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.tag.ECTags;

public class ElementExtractorBlockEntity
extends AbstractECBlockEntity
implements IContainerTopBlockEntity {
    private final int extractionAmount;
    private final RuneHandler runeHandler;
    private BlockCapabilityCache<IElementStorage, Direction> sourceCache;
    private ISingleElementStorage containerCache;

    public ElementExtractorBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.EXTRACTOR, pos, state);
        if (state.is((Block)ECBlocks.RUDIMENTARY_EXTRACTOR.get())) {
            this.extractionAmount = (Integer)ECConfig.SERVER.rudimentaryExtractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.rudimentaryExtractorMaxRunes.get(), this::setChanged);
        } else if (state.is((Block)ECBlocks.IMPROVED_EXTRACTOR.get())) {
            this.extractionAmount = (Integer)ECConfig.SERVER.improvedExtractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.improvedExtractorMaxRunes.get(), this::setChanged);
        } else {
            this.extractionAmount = (Integer)ECConfig.SERVER.extractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.extractorMaxRunes.get(), this::setChanged);
        }
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.getList("rune_handler", 8));
        }
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    protected Optional<BlockState> getSourceState() {
        return this.level != null ? Optional.of(this.level.getBlockState(this.worldPosition.above())) : Optional.empty();
    }

    public ElementType getSourceElementType() {
        return this.getSourceState().filter(s -> s.is(ECTags.Blocks.SOURCES)).map(ElementType::getElementType).orElse(ElementType.NONE);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ElementExtractorBlockEntity extractor) {
        Object object;
        BlockPos above = pos.above();
        if (extractor.sourceCache == null) {
            extractor.sourceCache = BlockCapabilityCache.create(ElementalCraftCapabilities.ElementStorage.BLOCK, (ServerLevel)((ServerLevel)level), (BlockPos)above, (Object)Direction.DOWN, () -> !extractor.isRemoved(), () -> {});
        }
        if (!extractor.canExtract() || !((object = extractor.sourceCache.getCapability()) instanceof SourceElementStorage)) {
            return;
        }
        SourceElementStorage sourceStorage = (SourceElementStorage)object;
        extractor.runeHandler.handleElementTransfer(sourceStorage, extractor.getContainer(), extractor.extractionAmount);
        if (sourceStorage.getElementAmount() <= 0) {
            if (sourceStorage.getSource().isStabilized()) {
                SingleStackContainer inv = new SingleStackContainer();
                inv.setItem(0, new ItemStack(ECItems.SOURCE_STABILIZER));
                RetrieverBlock.sendOutputToRetriever(level, pos, inv, 0);
                if (!inv.isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)above, (ItemStack)inv.getItem(0));
                }
            }
            level.removeBlock(above, false);
        }
    }

    public boolean canExtract() {
        SingleElementStorage sourceStorage;
        SourceElementStorage s;
        Object object;
        if (this.level == null || this.isPowered()) {
            return false;
        }
        if (this.sourceCache != null && (object = this.sourceCache.getCapability()) instanceof SourceElementStorage) {
            s = (SourceElementStorage)object;
            v0 = s;
        } else {
            v0 = sourceStorage = null;
        }
        if (sourceStorage == null) {
            object = this.level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, this.worldPosition.above(), (Object)Direction.DOWN);
            SingleElementStorage singleElementStorage = sourceStorage = object instanceof SourceElementStorage ? (s = (SourceElementStorage)object) : null;
        }
        if (sourceStorage == null) {
            return false;
        }
        ElementType sourceElementType = sourceStorage.getElementType();
        ISingleElementStorage container = this.getContainer();
        return this.hasLevel() && sourceElementType != ElementType.NONE && container != null && (container.getElementAmount() < container.getElementCapacity() || container.getElementType() != sourceElementType);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }
}

