/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.extractor;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.extractor.AbstractElementExtractorBlock;
import sirttas.elementalcraft.block.shape.ShapeHelper;

public class ElementExtractorBlock
extends AbstractElementExtractorBlock {
    public static final String NAME = "element_extractor";
    public static final MapCodec<ElementExtractorBlock> CODEC = ElementExtractorBlock.simpleCodec(ElementExtractorBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)1.0, (double)5.0, (double)16.0, (double)3.0, (double)11.0);
    private static final VoxelShape BASE_2 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_3 = Block.box((double)12.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_4 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape PILLAR_1 = Shapes.or((VoxelShape)Block.box((double)2.0, (double)3.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)4.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0), Block.box((double)2.0, (double)13.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0)});
    private static final VoxelShape PILLAR_2 = PILLAR_1.move(0.5, 0.0, 0.0);
    private static final VoxelShape SIDE_PILLAR_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)4.0, (double)3.0);
    private static final VoxelShape SIDE_PILLAR_2 = SIDE_PILLAR_1.move(0.75, 0.0, 0.0);
    private static final VoxelShape SIDE_PILLAR_3 = SIDE_PILLAR_1.move(0.0, 0.0, 0.75);
    private static final VoxelShape SIDE_PILLAR_4 = SIDE_PILLAR_1.move(0.75, 0.0, 0.75);
    private static final VoxelShape X_SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3, BASE_4, PILLAR_1, PILLAR_2, SIDE_PILLAR_1, SIDE_PILLAR_2, SIDE_PILLAR_3, SIDE_PILLAR_4});
    private static final VoxelShape Z_SHAPE = ShapeHelper.rotateShape(Direction.NORTH, Direction.EAST, X_SHAPE);

    public ElementExtractorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends ElementExtractorBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.X ? X_SHAPE : Z_SHAPE;
    }

    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, BlockStateProperties.HORIZONTAL_AXIS});
    }
}

