/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.container.IContainerBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class SingleItemRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final Vec3 position;
    private final float size;

    public SingleItemRenderer(Vec3 position) {
        this(position, 1.0f);
    }

    public SingleItemRenderer(Vec3 position, float size) {
        this.position = position;
        this.size = size;
    }

    public void render(@Nonnull T blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = ((IContainerBlockEntity)blockEntity).getInventory().getItem(0);
        ECRendererHelper.renderRunes(poseStack, buffer, blockEntity, partialTicks, light, overlay);
        if (!stack.isEmpty()) {
            poseStack.translate(this.position.x, this.position.y, this.position.z);
            poseStack.mulPose(Axis.YP.rotationDegrees(ECRendererHelper.getClientTicks(partialTicks)));
            poseStack.scale(this.size, this.size, this.size);
            ECRendererHelper.renderItem(stack, poseStack, buffer, light, overlay);
        }
    }
}

