/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity.renderer;

import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import sirttas.elementalcraft.block.container.ContainerRenderer;
import sirttas.elementalcraft.block.diffuser.DiffuserRenderer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.renderer.SingleItemRenderer;
import sirttas.elementalcraft.block.extractor.ExtractorRenderer;
import sirttas.elementalcraft.block.instrument.binder.BinderRenderer;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerRenderer;
import sirttas.elementalcraft.block.instrument.enchantment.liquefier.EnchantmentLiquefierRenderer;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberRenderer;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceRenderer;
import sirttas.elementalcraft.block.instrument.io.mill.MillRenderer;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierRenderer;
import sirttas.elementalcraft.block.pipe.ElementPipeRenderer;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserRenderer;
import sirttas.elementalcraft.block.shrine.ShrineRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.AccelerationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.overclocked.OverclockedAccelerationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.fortune.greater.GreaterFortuneShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.vortex.VortexShrineUpgradeRenderer;
import sirttas.elementalcraft.block.sorter.SorterRenderer;
import sirttas.elementalcraft.block.source.SourceRenderer;
import sirttas.elementalcraft.block.source.breeder.SourceBreederRenderer;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalRenderer;
import sirttas.elementalcraft.block.synthesizer.cracking.CrackingSynthesizerRenderer;
import sirttas.elementalcraft.block.synthesizer.draining.DrainingSynthesizerRenderer;
import sirttas.elementalcraft.block.synthesizer.mill.AirMillSynthesizerRenderer;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerRenderer;
import sirttas.elementalcraft.block.synthesizer.vibration.VibrationSynthesizerRenderer;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public final class ECRenderers {
    private ECRenderers() {
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterGeometryLoaders evt) {
        ECRenderers.register(ECBlockEntityTypes.PIPE, ElementPipeRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.INFUSER, () -> new SingleItemRenderer(new Vec3(0.5, 0.2, 0.5)));
        ECRenderers.register(ECBlockEntityTypes.EXTRACTOR, ExtractorRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.CRACKING_SYNTHESIZER, CrackingSynthesizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.COMBUSTION_SYNTHESIZER, () -> new SingleItemRenderer(new Vec3(0.5, 0.5, 0.5), 0.7f));
        ECRenderers.register(ECBlockEntityTypes.DRAINING_SYNTHESIZER, DrainingSynthesizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.VIBRATION_SYNTHESIZER, VibrationSynthesizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SOLAR_SYNTHESIZER, SolarSynthesizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SCULK_CRACKING_SYNTHESIZER, CrackingSynthesizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.AIR_MILL_SYNTHESIZER, AirMillSynthesizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.DIFFUSER, DiffuserRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.BINDER, BinderRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.BINDER_IMPROVED, BinderRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.CRYSTALLIZER, CrystallizerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.INSCRIBER, InscriberRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.WATER_MILL_GRINDSTONE, d -> new MillRenderer(MillRenderer.WATER_MILL_GRINDSTONE_SHAFT_LOCATION));
        ECRenderers.register(ECBlockEntityTypes.AIR_MILL_GRINDSTONE, d -> new MillRenderer(MillRenderer.AIR_MILL_GRINDSTONE_SHAFT_LOCATION));
        ECRenderers.register(ECBlockEntityTypes.WATER_MILL_WOOD_SAW, d -> new MillRenderer(MillRenderer.WATER_MILL_WOOD_SAW_SHAFT_LOCATION));
        ECRenderers.register(ECBlockEntityTypes.AIR_MILL_WOOD_SAW, d -> new MillRenderer(MillRenderer.AIR_MILL_WOOD_SAW_SHAFT_LOCATION));
        ECRenderers.register(ECBlockEntityTypes.ENCHANTMENT_LIQUEFIER, EnchantmentLiquefierRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.PEDESTAL, () -> new SingleItemRenderer(new Vec3(0.5, 0.9, 0.5)));
        ECRenderers.register(ECBlockEntityTypes.PURE_INFUSER, PureInfuserRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.FIRE_FURNACE, FireFurnaceRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.FIRE_BLAST_FURNACE, FireFurnaceRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.PURIFIER, PurifierRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.ACCELERATION_SHRINE_UPGRADE, AccelerationShrineUpgradeRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.VORTEX_SHRINE_UPGRADE, VortexShrineUpgradeRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.TRANSLOCATION_SHRINE_UPGRADE, TranslocationShrineUpgradeRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.OVERCLOCKED_ACCELERATION_SHRINE_UPGRADE, OverclockedAccelerationShrineUpgradeRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.GREATER_FORTUNE_SHRINE_UPGRADE, GreaterFortuneShrineUpgradeRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SORTER, SorterRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SOURCE, SourceRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.FIRE_PYLON, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.GROVE_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.BUDDING_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.BREEDING_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SPAWNING_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.LAVA_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.ORE_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.OVERLOAD_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SWEET_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.GROWTH_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.HARVEST_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.LUMBER_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.ENDER_LOCK_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SPRING_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.VACUUM_SHRINE, ShrineRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.CONTAINER, ContainerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.CREATIVE_CONTAINER, ContainerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.RESERVOIR, ContainerRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SOURCE_BREEDER, SourceBreederRenderer::new);
        ECRenderers.register(ECBlockEntityTypes.SOURCE_BREEDER_PEDESTAL, SourceBreederPedestalRenderer::new);
    }

    public static <T extends BlockEntity> void register(DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> type, Supplier<BlockEntityRenderer<? super T>> renderProvider) {
        ECRenderers.register((BlockEntityType)type.get(), renderProvider);
    }

    public static <T extends BlockEntity> void register(DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> type, BlockEntityRendererProvider<T> renderProvider) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)type.get()), renderProvider);
    }

    public static <T extends BlockEntity> void register(BlockEntityType<T> type, Supplier<BlockEntityRenderer<? super T>> renderProvider) {
        BlockEntityRenderers.register(type, d -> (BlockEntityRenderer)renderProvider.get());
    }
}

