/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity.crafting;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.block.entity.ICraftingBlockEntity;
import sirttas.elementalcraft.block.entity.crafting.CraftingBlockEntityProperties;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.container.IRuneableBlockEntity;

public abstract class AbstractECCraftingBlockEntity<I extends RecipeInput, R extends Recipe<I>>
extends AbstractECContainerBlockEntity
implements ICraftingBlockEntity,
IRuneableBlockEntity {
    protected final Holder<IConfigurableBlockEntityProperties> properties;
    protected final RuneHandler runeHandler;
    protected R recipe;
    protected boolean locked = false;

    protected AbstractECCraftingBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.properties = properties;
        this.runeHandler = new RuneHandler(this.getProperties().maxRunes(), this::setChanged);
    }

    public static <I extends RecipeInput, R extends Recipe<I>> void tick(AbstractECCraftingBlockEntity<I, R> blockEntity) {
        if (blockEntity.shouldRetrieverExtractOutput()) {
            blockEntity.retrieve();
        }
        if (blockEntity.locked) {
            blockEntity.updateLock();
        }
    }

    @Nonnull
    protected abstract I createRecipeInput();

    @Override
    public boolean isRecipeAvailable() {
        if (this.recipe != null && this.recipe.matches(this.createRecipeInput(), this.level)) {
            return true;
        }
        if (!this.getInventory().isEmpty()) {
            this.recipe = this.lookupRecipe();
            if (this.recipe != null) {
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    @Override
    public void process() {
        if (!this.level.isClientSide) {
            this.assemble();
        }
        this.recipe = null;
        this.updateLock();
        this.setChanged();
    }

    protected void retrieve() {
        if (this.getProperties().retrieveAll()) {
            for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
                RetrieverBlock.sendOutputToRetriever(this.level, this.worldPosition, this.getInventory(), i);
            }
        } else {
            RetrieverBlock.sendOutputToRetriever(this.level, this.worldPosition, this.getInventory(), this.getOutputSlot());
        }
    }

    protected int getProgressRounded(float transferAmount, float progress) {
        return Math.round(progress / (transferAmount * 3.0f));
    }

    protected abstract void assemble();

    @Nullable
    protected final R lookupRecipe() {
        return this.lookupRecipe(this.createRecipeInput());
    }

    @Nullable
    protected R lookupRecipe(@Nonnull I recipeInput) {
        return (R)(this.level != null ? this.lookupRecipe(this.level, this.getProperties().getRecipeType(), (RecipeInput)recipeInput) : null);
    }

    protected boolean shouldRetrieverExtractOutput() {
        return (!this.isLockable() || this.locked) && !this.getInventory().getItem(this.getOutputSlot()).isEmpty();
    }

    public boolean isLockable() {
        return this.getProperties().lockable();
    }

    public int getOutputSlot() {
        return this.getProperties().outputSlot();
    }

    protected void updateLock() {
        if (this.isLockable()) {
            this.locked = !this.getInventory().getItem(this.getOutputSlot()).isEmpty();
        }
    }

    public boolean isLocked() {
        return this.isLockable() && this.locked;
    }

    @Override
    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Nonnull
    public CraftingBlockEntityProperties getProperties() {
        Object object;
        if (this.properties.isBound() && (object = this.properties.value()) instanceof CraftingBlockEntityProperties) {
            CraftingBlockEntityProperties craftingBlockEntityProperties = (CraftingBlockEntityProperties)object;
            return craftingBlockEntityProperties;
        }
        return CraftingBlockEntityProperties.DEFAULT;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
        if (this.isLockable()) {
            compound.putBoolean("locked", this.locked);
        }
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.getList("rune_handler", 8));
        }
        if (this.isLockable() && compound.contains("locked")) {
            this.locked = compound.getBoolean("locked");
        }
    }

    public float getTransferSpeed() {
        return this.getProperties().transferSpeed();
    }
}

