/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.container.IElementStorageBlocKEntity;
import sirttas.elementalcraft.container.IRuneableBlockEntity;

public abstract class AbstractIERBlockEntity
extends AbstractECContainerBlockEntity
implements IRuneableBlockEntity,
IElementStorageBlocKEntity {
    protected AbstractIERBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        IElementStorage elementStorage = this.getElementStorage();
        if (compound.contains("element_storage") && elementStorage instanceof INBTSerializable) {
            ((INBTSerializable)elementStorage).deserializeNBT(provider, (Tag)compound.getCompound("element_storage"));
        }
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.getRuneHandler(), compound.getList("rune_handler", 8));
        }
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        IElementStorage elementStorage = this.getElementStorage();
        if (elementStorage instanceof INBTSerializable) {
            INBTSerializable serializable = (INBTSerializable)elementStorage;
            compound.put("element_storage", serializable.serializeNBT(provider));
        }
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.getRuneHandler()));
    }
}

