/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.container.IContainerBlockEntity;

public abstract class AbstractECContainerBlockEntity
extends AbstractECBlockEntity
implements IContainerBlockEntity {
    protected AbstractECContainerBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        Container inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            INBTSerializable nbtInv = (INBTSerializable)inv;
            if (compound.contains("inventory")) {
                nbtInv.deserializeNBT(provider, compound.get("inventory"));
            }
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        Container inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            INBTSerializable nbtInv = (INBTSerializable)inv;
            compound.put("inventory", nbtInv.serializeNBT(provider));
        }
    }
}

