/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractECBlockEntity
extends BlockEntity {
    private boolean dirty = true;

    protected AbstractECBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType.get(), pos, state);
    }

    public void setChanged() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isPowered() {
        return this.hasLevel() && this.getLevel().hasNeighborSignal(this.getBlockPos());
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public final CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void sendUpdate() {
        if (this.isDirty()) {
            super.setChanged();
            this.sendUpdatePacket();
            this.dirty = false;
        }
    }

    private void sendUpdatePacket() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false).forEach(e -> e.connection.send((Packet)packet));
        }
    }
}

