/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import sirttas.elementalcraft.block.diffuser.DiffuserBlockEntity;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class DiffuserRenderer
implements BlockEntityRenderer<DiffuserBlockEntity> {
    public static final ModelResourceLocation CUBE_LOCATION = ECModelHelper.standalone("block/diffuser_cube");
    private static final Quaternionf ROTATION = Axis.XP.rotationDegrees(45.0f);
    private BakedModel cubeModel;

    public void render(@Nonnull DiffuserBlockEntity diffuser, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int light, int overlay) {
        if (diffuser.showsRange()) {
            BlockPos pos = diffuser.getBlockPos();
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)bufferSource.getBuffer(RenderType.lines()), (AABB)diffuser.getRange().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())), (float)1.0f, (float)1.0f, (float)0.6f, (float)1.0f);
        }
        float angle = ECRendererHelper.getClientTicks(partialTicks);
        if (this.cubeModel == null) {
            this.cubeModel = Minecraft.getInstance().getModelManager().getModel(CUBE_LOCATION);
        }
        ECRendererHelper.renderRunes(poseStack, bufferSource, diffuser.getRuneHandler(), angle, light, overlay);
        poseStack.pushPose();
        poseStack.translate(0.5, 1.1, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        poseStack.mulPose(ROTATION);
        poseStack.translate(-0.1875, -0.1875, -0.1875);
        ECRendererHelper.renderModel(this.cubeModel, poseStack, bufferSource, diffuser, light, overlay);
        poseStack.popPose();
    }

    static {
        ROTATION.mul((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
    }
}

