/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.range.Range;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.range.RangeRenderTimer;
import sirttas.elementalcraft.range.Ranges;

public class DiffuserBlockEntity
extends AbstractECBlockEntity
implements IContainerTopBlockEntity {
    private static final Holder<Range> RANGE = ElementalCraftApi.RANGE_MANAGER.getOrCreateHolder(Ranges.DIFFUSER);
    private boolean hasDiffused;
    private final RuneHandler runeHandler;
    private final RangeRenderTimer rangeRenderTimer;
    private ISingleElementStorage containerCache;

    public DiffuserBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.DIFFUSER, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.diffuserMaxRunes.get(), this::setChanged);
        this.rangeRenderTimer = new RangeRenderTimer();
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.hasDiffused = compound.getBoolean("has_diffused");
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.getList("rune_handler", 8));
        }
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putBoolean("has_diffused", this.hasDiffused);
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DiffuserBlockEntity diffuser) {
        ISingleElementStorage container = diffuser.getContainer();
        AtomicInteger amount = new AtomicInteger((Integer)ECConfig.SERVER.diffuserDiffusionAmount.get());
        diffuser.hasDiffused = false;
        if (container != null && !container.isEmpty()) {
            level.getEntities(null, diffuser.getRange()).stream().map(e -> (IElementStorage)e.getCapability(ElementalCraftCapabilities.ElementStorage.ENTITY, null)).filter(Objects::nonNull).forEach(storage -> {
                if (!container.isEmpty() && amount.get() > 0 && container.transferTo((IElementStorage)storage, container.getElementType(), diffuser.runeHandler.getTransferSpeed(amount.get()), Math.min(1.0f, diffuser.runeHandler.getElementPreservation())) > 0) {
                    diffuser.hasDiffused = true;
                }
            });
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, DiffuserBlockEntity diffuser) {
        diffuser.rangeRenderTimer.tick();
    }

    public boolean showsRange() {
        return this.rangeRenderTimer.showsRange();
    }

    public void startShowingRange() {
        this.rangeRenderTimer.startShowingRange();
    }

    public AABB getRange() {
        return this.runeHandler.getRange((Range)RANGE.value()).move(this.worldPosition);
    }

    public boolean hasDiffused() {
        return this.hasDiffused;
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }
}

