/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.diffuser.DiffuserBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.particle.ParticleHelper;

public class DiffuserBlock
extends AbstractECEntityBlock {
    public static final String NAME = "diffuser";
    public static final MapCodec<DiffuserBlock> CODEC = DiffuserBlock.simpleCodec(DiffuserBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape PILLAR = Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    private static final VoxelShape SIDE_PILLAR_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)3.0);
    private static final VoxelShape SIDE_PILLAR_2 = SIDE_PILLAR_1.move(0.75, 0.0, 0.0);
    private static final VoxelShape SIDE_PILLAR_3 = SIDE_PILLAR_1.move(0.0, 0.0, 0.75);
    private static final VoxelShape SIDE_PILLAR_4 = SIDE_PILLAR_1.move(0.75, 0.0, 0.75);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PILLAR, SIDE_PILLAR_1, SIDE_PILLAR_2, SIDE_PILLAR_3, SIDE_PILLAR_4});

    public DiffuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<DiffuserBlock> codec() {
        return CODEC;
    }

    public DiffuserBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new DiffuserBlockEntity(pos, state);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        DiffuserBlockEntity diffuser = (DiffuserBlockEntity)level.getBlockEntity(pos);
        if (diffuser != null && player.getItemInHand(hand).isEmpty() && player.isShiftKeyDown()) {
            if (level.isClientSide) {
                diffuser.startShowingRange();
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return DiffuserBlock.createECTicker(level, type, ECBlockEntityTypes.DIFFUSER, level.isClientSide ? DiffuserBlockEntity::clientTick : DiffuserBlockEntity::serverTick);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, DiffuserBlockEntity.class).filter(DiffuserBlockEntity::hasDiffused).ifPresent(e -> ParticleHelper.createElementFlowParticle(e.getContainerElementType(), level, Vec3.atCenterOf((Vec3i)pos), Direction.UP, 1.0f, rand));
    }
}

