/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container.reservoir;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.container.AbstractConnectedElementContainerBlock;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlockEntity;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;

public class ReservoirBlock
extends AbstractConnectedElementContainerBlock
implements IElementTypeProvider {
    public static final String NAME = "reservoir";
    public static final String NAME_FIRE = "reservoir_fire";
    public static final String NAME_WATER = "reservoir_water";
    public static final String NAME_EARTH = "reservoir_earth";
    public static final String NAME_AIR = "reservoir_air";
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY_FIRE = IConfigurableBlockEntityProperties.createKey("reservoir_fire");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES_FIRE = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY_FIRE);
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY_WATER = IConfigurableBlockEntityProperties.createKey("reservoir_water");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES_WATER = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY_WATER);
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY_EARTH = IConfigurableBlockEntityProperties.createKey("reservoir_earth");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES_EARTH = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY_EARTH);
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY_AIR = IConfigurableBlockEntityProperties.createKey("reservoir_air");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES_AIR = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY_AIR);
    public static final MapCodec<ReservoirBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(ElementType.forGetter(ReservoirBlock::getElementType), (App)ReservoirBlock.propertiesCodec()).apply((Applicative)instance, ReservoirBlock::new));
    private static final VoxelShape UPPER_GLASS = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape UPPER_PIPE_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape UPPER_PIPE_2 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape UPPER_PIPE_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_PIPE_4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_CONNECTOR = Block.box((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape UPPER_SHAPE = Shapes.or((VoxelShape)UPPER_GLASS, (VoxelShape[])new VoxelShape[]{UPPER_PIPE_1, UPPER_PIPE_2, UPPER_PIPE_3, UPPER_PIPE_4, UPPER_CONNECTOR});
    private static final VoxelShape LOWER_GLASS_1 = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape LOWER_GLASS_2 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape LOWER_PIPE_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
    private static final VoxelShape LOWER_PIPE_2 = Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape LOWER_PIPE_3 = Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_PIPE_4 = Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_WALL_NORTH = Block.box((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)9.0, (double)3.0);
    private static final VoxelShape LOWER_WALL_SOUTH = Block.box((double)4.0, (double)2.0, (double)13.0, (double)12.0, (double)9.0, (double)15.0);
    private static final VoxelShape LOWER_WALL_WEST = Block.box((double)1.0, (double)2.0, (double)4.0, (double)3.0, (double)9.0, (double)12.0);
    private static final VoxelShape LOWER_WALL_EAST = Block.box((double)13.0, (double)2.0, (double)4.0, (double)15.0, (double)9.0, (double)12.0);
    private static final VoxelShape LOWER_PLATE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape LOWER_BASE = Shapes.or((VoxelShape)LOWER_GLASS_1, (VoxelShape[])new VoxelShape[]{LOWER_GLASS_2, LOWER_PIPE_1, LOWER_PIPE_2, LOWER_PIPE_3, LOWER_PIPE_4, LOWER_WALL_NORTH, LOWER_WALL_SOUTH, LOWER_WALL_WEST, LOWER_WALL_EAST, LOWER_PLATE});
    private static final VoxelShape EARTH_WALL_NORTH = Block.box((double)4.0, (double)9.0, (double)1.0, (double)12.0, (double)14.0, (double)3.0);
    private static final VoxelShape EARTH_WALL_SOUTH = Block.box((double)4.0, (double)9.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0);
    private static final VoxelShape EARTH_WALL_WEST = Block.box((double)1.0, (double)9.0, (double)4.0, (double)3.0, (double)14.0, (double)12.0);
    private static final VoxelShape EARTH_WALL_EAST = Block.box((double)13.0, (double)9.0, (double)4.0, (double)15.0, (double)14.0, (double)12.0);
    private static final VoxelShape LOWER_EARTH = Shapes.or((VoxelShape)LOWER_BASE, (VoxelShape[])new VoxelShape[]{EARTH_WALL_NORTH, EARTH_WALL_SOUTH, EARTH_WALL_WEST, EARTH_WALL_EAST});
    private static final VoxelShape AIR_PIPE_1 = Block.box((double)1.0, (double)5.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape AIR_PIPE_2 = Block.box((double)13.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape AIR_PIPE_3 = Block.box((double)1.0, (double)5.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape AIR_PIPE_4 = Block.box((double)13.0, (double)5.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape AIR_PLATE = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape AIR_PLATE_2 = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    private static final VoxelShape LOWER_AIR = Shapes.or((VoxelShape)LOWER_GLASS_1, (VoxelShape[])new VoxelShape[]{AIR_PIPE_1, AIR_PIPE_2, AIR_PIPE_3, AIR_PIPE_4, AIR_PLATE, AIR_PLATE_2});
    private static final VoxelShape AIR_CONNECTOR_NORTH = Shapes.or((VoxelShape)Block.box((double)4.0, (double)5.0, (double)1.0, (double)12.0, (double)12.0, (double)2.0), (VoxelShape)Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0));
    private static final VoxelShape AIR_CONNECTOR_SOUTH = Shapes.or((VoxelShape)Block.box((double)4.0, (double)5.0, (double)14.0, (double)12.0, (double)12.0, (double)15.0), (VoxelShape)Block.box((double)5.0, (double)6.0, (double)15.0, (double)11.0, (double)11.0, (double)16.0));
    private static final VoxelShape AIR_CONNECTOR_WEST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)5.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0));
    private static final VoxelShape AIR_CONNECTOR_EAST = Shapes.or((VoxelShape)Block.box((double)14.0, (double)5.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)15.0, (double)6.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private final ElementType elementType;

    public ReservoirBlock(ElementType elementType, BlockBehaviour.Properties properties) {
        super(properties, switch (elementType) {
            default -> throw new MatchException(null, null);
            case ElementType.FIRE -> PROPERTIES_FIRE;
            case ElementType.WATER -> PROPERTIES_WATER;
            case ElementType.EARTH -> PROPERTIES_EARTH;
            case ElementType.AIR -> PROPERTIES_AIR;
            case ElementType.NONE -> throw new IllegalArgumentException("Cannot create a reservoir for NONE");
        });
        this.elementType = elementType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? new ReservoirBlockEntity(pos, state) : null;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    public void setPlacedBy(Level level, BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        AbstractPylonShrineBlock.doubleHalfHarvest(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        if (!AbstractPylonShrineBlock.canReplaceAboveBlock(context)) {
            return null;
        }
        return super.getStateForPlacement(context);
    }

    @Override
    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return AbstractPylonShrineBlock.doubleHalfUpdateShape(state, facing, facingState, level, pos, () -> super.updateShape(state, facing, facingState, level, pos, facingPos));
    }

    public boolean canSurvive(BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER || level.getBlockState(pos.below()).is((Block)this);
    }

    @Override
    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape shape;
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            shape = UPPER_SHAPE;
        } else {
            switch (this.elementType) {
                case AIR: {
                    VoxelShape voxelShape = LOWER_AIR;
                    break;
                }
                case EARTH: {
                    VoxelShape voxelShape = LOWER_EARTH;
                    break;
                }
                default: {
                    VoxelShape voxelShape = shape = LOWER_BASE;
                }
            }
            if (this.elementType == ElementType.AIR) {
                if (Boolean.TRUE.equals(state.getValue((Property)NORTH))) {
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)AIR_CONNECTOR_NORTH);
                }
                if (Boolean.TRUE.equals(state.getValue((Property)SOUTH))) {
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)AIR_CONNECTOR_SOUTH);
                }
                if (Boolean.TRUE.equals(state.getValue((Property)EAST))) {
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)AIR_CONNECTOR_EAST);
                }
                if (Boolean.TRUE.equals(state.getValue((Property)WEST))) {
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape)AIR_CONNECTOR_WEST);
                }
                return shape;
            }
        }
        return Shapes.or((VoxelShape)shape, (VoxelShape)super.getShape(state, level, pos, context));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{HALF, NORTH, SOUTH, EAST, WEST});
    }

    @Override
    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            super.animateTick(state, level, pos, rand);
        }
    }

    @NotNull
    protected MapCodec<ReservoirBlock> codec() {
        return CODEC;
    }
}

