/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.gui.GuiHelper;

public class ElementContainerBlockItem
extends BlockItem {
    public ElementContainerBlockItem(AbstractElementContainerBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public int getBarColor(@Nonnull ItemStack stack) {
        return ((ElementType)stack.getOrDefault(ECDataComponents.ELEMENT_TYPE, (Object)ElementType.NONE)).getColor();
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        ElementType elementType = (ElementType)stack.getOrDefault(ECDataComponents.ELEMENT_TYPE, (Object)ElementType.NONE);
        int amount = (Integer)stack.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0);
        int capacity = ((AbstractElementContainerBlock)this.getBlock()).getDefaultCapacity();
        if (elementType != ElementType.NONE && amount > 0) {
            return Optional.of(new Tooltip(elementType, amount, capacity));
        }
        return Optional.empty();
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        int amount = (Integer)stack.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0);
        int capacity = ((AbstractElementContainerBlock)this.getBlock()).getDefaultCapacity();
        if (amount > 0) {
            return Math.round((float)amount * 13.0f / (float)capacity);
        }
        return 0;
    }

    public record Tooltip(ElementType elementType, int amount, int capacity) implements TooltipComponent
    {
    }

    public record ClientTooltip(ElementType elementType, int amount, int capacity) implements ClientTooltipComponent
    {
        public ClientTooltip(Tooltip tooltip) {
            this(tooltip.elementType, tooltip.amount, tooltip.capacity);
        }

        public int getHeight() {
            return 18;
        }

        public int getWidth(@Nonnull Font font) {
            return 16;
        }

        public void renderImage(@Nonnull Font font, int x, int y, @Nonnull GuiGraphics guiGraphics) {
            GuiHelper.renderElementGauge(guiGraphics, font, x, y, this.amount, this.capacity, this.elementType, false);
        }
    }
}

