/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.container.AbstractConnectedElementContainerBlock;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;

public class ElementContainerBlock
extends AbstractConnectedElementContainerBlock {
    public static final String NAME = "container";
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("container");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    public static final MapCodec<ElementContainerBlock> CODEC = ElementContainerBlock.simpleCodec(ElementContainerBlock::new);
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape GLASS = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape PIPE_1 = Block.box((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape PIPE_2 = Block.box((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape PIPE_3 = Block.box((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape PIPE_4 = Block.box((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape CONNECTOR = Block.box((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{GLASS, PIPE_1, PIPE_2, PIPE_3, PIPE_4, CONNECTOR});

    public ElementContainerBlock(BlockBehaviour.Properties properties) {
        this(properties, PROPERTIES);
    }

    protected ElementContainerBlock(BlockBehaviour.Properties properties, Holder<IConfigurableBlockEntityProperties> entityProperties) {
        super(properties, entityProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.or((VoxelShape)SHAPE, (VoxelShape)super.getShape(state, level, pos, context));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    @NotNull
    protected MapCodec<? extends ElementContainerBlock> codec() {
        return CODEC;
    }
}

