/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;

public interface ElementContainer {
    public static final BlockCapability<ElementContainer, Void> CAPABILITY = BlockCapability.createVoid((ResourceLocation)ElementalCraftApi.createRL("element_container"), ElementContainer.class);

    public HolderSet<Block> getCompatibleTools();

    public ISingleElementStorage getElementStorage();

    @Nullable
    default public ISingleElementStorage getElementStorage(@Nullable BlockState instrumentState) {
        if (instrumentState == null || instrumentState.is(this.getCompatibleTools())) {
            return this.getElementStorage();
        }
        return null;
    }

    @Nullable
    public static ISingleElementStorage getElementContainer(@Nonnull ILevelExtension level, @Nonnull BlockPos pos) {
        return ElementContainer.getElementContainer(null, level, pos);
    }

    @Nullable
    public static ISingleElementStorage getElementContainer(@Nullable BlockState state, @Nonnull ILevelExtension level, @Nonnull BlockPos pos) {
        ElementContainer container = (ElementContainer)level.getCapability(CAPABILITY, pos);
        if (container != null) {
            return container.getElementStorage(state);
        }
        return null;
    }

    public static boolean isValidContainer(@Nullable BlockState state, @Nullable LevelReader levelReader, @Nonnull BlockPos pos) {
        if (!(levelReader instanceof ILevelExtension)) {
            return true;
        }
        ILevelExtension level = (ILevelExtension)levelReader;
        return ElementContainer.getElementContainer(state, level, pos) != null;
    }
}

