/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class ContainerRenderer<T extends AbstractElementContainerBlockEntity>
implements BlockEntityRenderer<T> {
    public void render(@Nonnull T container, float pPartialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (Boolean.FALSE.equals(ECConfig.CLIENT.renderInstrumentShadow.get())) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = container.getLevel();
        if (level == null || player == null) {
            return;
        }
        BlockPos pos = container.getBlockPos();
        Iterator<ItemStack> iterator = List.of(player.getMainHandItem(), player.getOffhandItem()).iterator();
        boolean wasRendered = false;
        while (iterator.hasNext() && !wasRendered) {
            BlockState state;
            ItemStack stack = iterator.next();
            Item item = stack.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockPos instrumentPos = pos.above(container instanceof ReservoirBlockEntity ? 2 : 1);
            if (!level.getBlockState(instrumentPos).isAir() || (state = block.getStateForPlacement((BlockPlaceContext)new DirectionalPlaceContext(level, instrumentPos, Direction.DOWN, stack, Direction.UP))) == null || !state.canSurvive((LevelReader)level, instrumentPos) || !state.is(((AbstractElementContainerBlockEntity)container).getCompatibleTools())) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 1.0f, 0.0f);
            ECRendererHelper.renderGhost(state, poseStack, bufferSource, level, instrumentPos);
            poseStack.popPose();
            wasRendered = true;
        }
    }
}

