/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.container.ElementContainerProperties;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.container.IElementStorageBlocKEntity;

public abstract class AbstractElementContainerBlockEntity
extends AbstractECBlockEntity
implements ElementContainer,
IElementStorageBlocKEntity {
    protected final SingleElementStorage elementStorage;

    protected AbstractElementContainerBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Function<AbstractElementContainerBlockEntity, SingleElementStorage> elementStorage, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.elementStorage = elementStorage.apply(this);
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("element_storage")) {
            this.elementStorage.deserializeNBT(provider, compound.getCompound("element_storage"));
        }
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("element_storage", (Tag)this.elementStorage.serializeNBT(provider));
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    protected abstract void setElementType(ElementType var1);

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.setElementType((ElementType)input.getOrDefault(ECDataComponents.ELEMENT_TYPE, (Object)ElementType.NONE));
        this.elementStorage.setElementAmount((Integer)input.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ECDataComponents.ELEMENT_TYPE, (Object)this.elementStorage.getElementType());
        builder.set(ECDataComponents.ELEMENT_AMOUNT, (Object)this.elementStorage.getElementAmount());
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("element_storage");
    }

    @Override
    @Nonnull
    public HolderSet<Block> getCompatibleTools() {
        return this.getProperties().compatibleTools();
    }

    @Nonnull
    public ElementContainerProperties getProperties() {
        return ((AbstractElementContainerBlock)this.getBlockState().getBlock()).getProperties();
    }
}

