/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.container.ElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.ElementContainerProperties;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractElementContainerBlock
extends AbstractECEntityBlock {
    private final Holder<IConfigurableBlockEntityProperties> entityProperties;

    protected AbstractElementContainerBlock(BlockBehaviour.Properties properties, Holder<IConfigurableBlockEntityProperties> entityProperties) {
        super(properties);
        this.entityProperties = entityProperties;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ElementContainerBlockEntity(pos, state);
    }

    public boolean hasAnalogOutputSignal(@Nonnull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos) {
        ISingleElementStorage storage = ElementContainer.getElementContainer((ILevelExtension)level, pos);
        if (storage == null || storage.isEmpty()) {
            return 0;
        }
        return storage.getElementAmount() * 15 / storage.getElementCapacity();
    }

    public float getShadeBrightness(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        ISingleElementStorage storage = ElementContainer.getElementContainer((ILevelExtension)level, pos);
        if (storage == null || storage.isEmpty()) {
            return;
        }
        ParticleHelper.createSourceParticle(storage.getElementType(), level, Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.2, 0.0), rand);
    }

    @Override
    public void onRemove(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos up;
        if (!state.is(newState.getBlock()) && level.getBlockState(up = pos.above()).is(ECTags.Blocks.CONTAINER_TOOLS)) {
            level.destroyBlock(up, true);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nonnull
    public ElementContainerProperties getProperties() {
        Object object;
        if (this.entityProperties.isBound() && (object = this.entityProperties.value()) instanceof ElementContainerProperties) {
            ElementContainerProperties elementContainerProperties = (ElementContainerProperties)object;
            return elementContainerProperties;
        }
        return ElementContainerProperties.DEFAULT;
    }

    public int getDefaultCapacity() {
        return this.getProperties().capacity();
    }
}

