/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.pipe.IPipeConnectedBlock;

public abstract class AbstractConnectedElementContainerBlock
extends AbstractElementContainerBlock
implements IPipeConnectedBlock {
    private static final VoxelShape CONNECTOR_NORTH = Shapes.or((VoxelShape)Block.box((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)2.0), (VoxelShape)Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0));
    private static final VoxelShape CONNECTOR_SOUTH = Shapes.or((VoxelShape)Block.box((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)15.0), (VoxelShape)Block.box((double)6.0, (double)6.0, (double)15.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape CONNECTOR_WEST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)10.0));
    private static final VoxelShape CONNECTOR_EAST = Shapes.or((VoxelShape)Block.box((double)14.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (VoxelShape)Block.box((double)15.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));

    protected AbstractConnectedElementContainerBlock(BlockBehaviour.Properties properties, Holder<IConfigurableBlockEntityProperties> entityProperties) {
        super(properties, entityProperties);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape shape = Shapes.empty();
        if (Boolean.TRUE.equals(state.getValue((Property)NORTH))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_NORTH);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)SOUTH))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_SOUTH);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)EAST))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_EAST);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)WEST))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_WEST);
        }
        return shape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.doGetStateForPlacement((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return this.doUpdateShape(state, (BlockGetter)level, currentPos, facing);
    }
}

