/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.anchor;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class TranslocationAnchorsSaveData
extends SavedData {
    public static final Set<BlockPos> CLIENT_SET = new HashSet<BlockPos>();
    private final Set<BlockPos> set;

    public TranslocationAnchorsSaveData() {
        this.set = new HashSet<BlockPos>();
    }

    public TranslocationAnchorsSaveData(@Nonnull CompoundTag compoundTag, @Nonnull HolderLookup.Provider provider) {
        ListTag tagList = compoundTag.getList("list", 10);
        this.set = HashSet.newHashSet(tagList.size());
        for (int i = 0; i < tagList.size(); ++i) {
            NbtUtils.readBlockPos((CompoundTag)tagList.getCompound(i), (String)"pos").ifPresent(this.set::add);
        }
    }

    @Nullable
    public static TranslocationAnchorsSaveData get(@Nonnull Level level) {
        TranslocationAnchorsSaveData translocationAnchorsSaveData;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            translocationAnchorsSaveData = (TranslocationAnchorsSaveData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(TranslocationAnchorsSaveData::new, TranslocationAnchorsSaveData::new, null), "elementalcraft_translocation_anchors");
        } else {
            translocationAnchorsSaveData = null;
        }
        return translocationAnchorsSaveData;
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        ListTag tagList = new ListTag();
        for (BlockPos blockPos : this.set) {
            CompoundTag tag = new CompoundTag();
            tag.put("pos", NbtUtils.writeBlockPos((BlockPos)blockPos));
            tagList.add((Object)tag);
        }
        compoundTag.put("list", (Tag)tagList);
        return compoundTag;
    }

    public Set<BlockPos> getAnchors() {
        return Set.copyOf(this.set);
    }

    public void addAnchor(BlockPos pos) {
        this.set.add(pos);
        this.setDirty();
    }

    public void removeAnchor(BlockPos pos) {
        this.set.remove(pos);
        this.setDirty();
    }
}

