/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.anchor;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorsSaveData;
import sirttas.elementalcraft.network.payload.PayloadHelper;

public record TranslocationAnchorListPayload(List<BlockPos> list) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TranslocationAnchorListPayload> TYPE = PayloadHelper.createType("translocation_anchor_list");
    public static final StreamCodec<FriendlyByteBuf, TranslocationAnchorListPayload> STREAM_CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), TranslocationAnchorListPayload::new);

    public TranslocationAnchorListPayload(FriendlyByteBuf buf) {
        this(buf.readList(b -> BlockPos.of((long)b.readLong())));
    }

    public static TranslocationAnchorListPayload create(Level level) {
        TranslocationAnchorsSaveData anchorList = TranslocationAnchorsSaveData.get(level);
        if (anchorList != null) {
            return new TranslocationAnchorListPayload(List.copyOf(anchorList.getAnchors()));
        }
        return new TranslocationAnchorListPayload(Collections.emptyList());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeCollection(this.list, (b, p) -> b.writeLong(p.asLong()));
    }

    @NotNull
    public CustomPacketPayload.Type<TranslocationAnchorListPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext payloadContext) {
        payloadContext.enqueueWork(() -> {
            TranslocationAnchorsSaveData.CLIENT_SET.clear();
            TranslocationAnchorsSaveData.CLIENT_SET.addAll(this.list);
        });
    }
}

