/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.anchor;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorListPayload;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorsSaveData;
import sirttas.elementalcraft.block.shape.ECShapes;

public class TranslocationAnchorBlock
extends Block {
    public static final String NAME = "translocation_anchor";
    public static final MapCodec<TranslocationAnchorBlock> CODEC = TranslocationAnchorBlock.simpleCodec(TranslocationAnchorBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)ECShapes.SOURCE_DISPLACEMENT_PLATE_SHAPE, (VoxelShape)Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0));

    public TranslocationAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<TranslocationAnchorBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@Nonnull BlockState state, LevelReader level, BlockPos pos) {
        BlockPos bellow = pos.below();
        return level.getBlockState(bellow).isFaceSturdy((BlockGetter)level, bellow, Direction.UP) && super.canSurvive(state, level, pos);
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        TranslocationAnchorsSaveData anchorList;
        if (!oldState.is((Block)this) && (anchorList = TranslocationAnchorsSaveData.get(level)) != null) {
            anchorList.addAnchor(pos);
            this.sendToPlayers(level);
        }
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void onRemove(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        TranslocationAnchorsSaveData anchorList;
        if (!newState.is((Block)this) && (anchorList = TranslocationAnchorsSaveData.get(level)) != null) {
            anchorList.removeAnchor(pos);
            this.sendToPlayers(level);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void sendToPlayers(@Nonnull Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)TranslocationAnchorListPayload.create(level), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }
}

