/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.airmill;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import sirttas.elementalcraft.block.airmill.AirMill;
import sirttas.elementalcraft.component.ECDataComponents;

public class AirMillBlockItemModel
extends BakedModelWrapper<BakedModel> {
    private final ItemOverrides overrides;

    public AirMillBlockItemModel(ModelResourceLocation originalName, BakedModel original) {
        super(original);
        final ModelResourceLocation brokenModel = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)originalName.id().getNamespace(), (String)("item/" + originalName.id().getPath() + "_broken")));
        this.overrides = new ItemOverrides(this){

            public BakedModel resolve(@Nonnull BakedModel original, @Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
                Integer damage = (Integer)stack.getComponents().getOrDefault((DataComponentType)ECDataComponents.AIR_MILL_DAMAGE.get(), (Object)0);
                if (damage < AirMill.getMaxDamage()) {
                    return original;
                }
                return Minecraft.getInstance().getModelManager().getModel(brokenModel);
            }
        };
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return this.overrides;
    }
}

