/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.airmill;

import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.airmill.AirMill;
import sirttas.elementalcraft.component.ECDataComponents;

public class AirMillBlockItem
extends BlockItem {
    public AirMillBlockItem(Block block, Item.Properties properties) {
        super(block, properties.component(ECDataComponents.AIR_MILL_DAMAGE, (Object)0));
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        int damage = this.getAirMillDamage(stack);
        return damage > 0 && damage < AirMill.getMaxDamage();
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        int maxDamage = AirMill.getMaxDamage();
        int damage = this.getAirMillDamage(stack);
        if (damage > 0) {
            return Math.round((float)(maxDamage - damage) * 13.0f / (float)maxDamage);
        }
        return 0;
    }

    public int getBarColor(@Nonnull ItemStack stack) {
        int maxDamage = AirMill.getMaxDamage();
        float f = Math.max(0.0f, ((float)maxDamage - (float)this.getAirMillDamage(stack)) / (float)maxDamage);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    private int getAirMillDamage(@NotNull ItemStack stack) {
        return (Integer)stack.getComponents().getOrDefault((DataComponentType)ECDataComponents.AIR_MILL_DAMAGE.get(), (Object)0);
    }
}

