/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.airmill;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractAirMillBlock;
import sirttas.elementalcraft.item.ECItems;

public interface AirMill {
    public int getDamage();

    public void setDamage(int var1);

    default public boolean isBroken() {
        return this.getDamage() >= AirMill.getMaxDamage();
    }

    public static int getMaxDamage() {
        ItemStack stack = new ItemStack(ECItems.AIR_MILL);
        return stack.getMaxDamage();
    }

    public static ItemInteractionResult setMill(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AirMill)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AirMill mill = (AirMill)blockEntity;
        int damage = stack.getDamageValue();
        int maxDamage = AirMill.getMaxDamage();
        int millDamage = mill.getDamage();
        if (millDamage <= 0) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int repair = Math.min(millDamage, maxDamage - damage);
        if (repair <= 0) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        mill.setDamage(millDamage - repair);
        level.setBlock(pos, (BlockState)state.setValue((Property)AbstractAirMillBlock.BROKEN, (Comparable)Boolean.valueOf(false)), 3);
        if (!player.getAbilities().instabuild) {
            stack.setDamageValue(damage + repair);
            if (stack.getDamageValue() >= maxDamage) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

