/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WaterLoggingHelper {
    private WaterLoggingHelper() {
    }

    public static boolean isWaterlogged(BlockState state) {
        return state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElse(false);
    }

    public static void scheduleWaterTick(BlockState state, LevelAccessor level, BlockPos pos) {
        if (WaterLoggingHelper.isWaterlogged(state)) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
    }

    public static boolean isPlacedInWater(BlockPlaceContext context) {
        return context.getLevel().getFluidState(context.getClickedPos()).is(FluidTags.WATER);
    }
}

