/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlock;
import sirttas.elementalcraft.block.container.SmallElementContainerBlock;
import sirttas.elementalcraft.block.container.creative.CreativeElementContainerBlock;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlock;
import sirttas.elementalcraft.block.diffuser.DiffuserBlock;
import sirttas.elementalcraft.block.extractor.ElementExtractorBlock;
import sirttas.elementalcraft.block.extractor.ImprovedElementExtractorBlock;
import sirttas.elementalcraft.block.extractor.RudimentaryElementExtractorBlock;
import sirttas.elementalcraft.block.instrument.binder.BinderBlock;
import sirttas.elementalcraft.block.instrument.binder.improved.ImprovedBinderBlock;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlock;
import sirttas.elementalcraft.block.instrument.enchantment.liquefier.EnchantmentLiquefierBlock;
import sirttas.elementalcraft.block.instrument.infuser.InfuserBlock;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlock;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceBlock;
import sirttas.elementalcraft.block.instrument.io.firefurnace.blast.FireBlastFurnaceBlock;
import sirttas.elementalcraft.block.instrument.io.mill.grindstone.air.AirMillGrindstoneBlock;
import sirttas.elementalcraft.block.instrument.io.mill.grindstone.water.WaterMillGrindstoneBlock;
import sirttas.elementalcraft.block.instrument.io.mill.woodsaw.air.AirMillWoodSawBlock;
import sirttas.elementalcraft.block.instrument.io.mill.woodsaw.water.WaterMillWoodSawBlock;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlock;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlock;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlock;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlock;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlock;
import sirttas.elementalcraft.block.shrine.grove.GroveShrineBlock;
import sirttas.elementalcraft.block.shrine.growth.GrowthShrineBlock;
import sirttas.elementalcraft.block.shrine.harvest.HarvestShrineBlock;
import sirttas.elementalcraft.block.shrine.lumber.LumberShrineBlock;
import sirttas.elementalcraft.block.shrine.melting.MeltingShrineBlock;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlock;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlock;
import sirttas.elementalcraft.block.shrine.spawning.SpawningShrineBlock;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlock;
import sirttas.elementalcraft.block.shrine.sweet.SweetShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.AccelerationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.overclocked.OverclockedAccelerationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.CapacityShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.EfficiencyShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.FillingShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.OptimizationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.RangeShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.fortune.FortuneShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.fortune.greater.GreaterFortuneShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.CrystalHarvestShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.NectarShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.ProtectionShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SilkTouchShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SpringalineShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.strength.OverwhelmingStrengthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.strength.StrengthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.BonelessGrowthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.CrystalGrowthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.MysticalGroveShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.PickupShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.StemPollinationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.vertical.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.vortex.VortexShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.vacuum.VacuumShrineBlock;
import sirttas.elementalcraft.block.sorter.SorterBlock;
import sirttas.elementalcraft.block.source.SourceBlock;
import sirttas.elementalcraft.block.source.breeder.SourceBreederBlock;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlock;
import sirttas.elementalcraft.block.spelldesk.SpellDeskBlock;
import sirttas.elementalcraft.block.synthesizer.combustion.CombustionSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.cracking.CrackingSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.cracking.sculk.SculkCrackingSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.culinary.CulinarySynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.draining.DrainingSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.mill.AirMillSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.vibration.VibrationSynthesizerBlock;
import sirttas.elementalcraft.property.ECProperties;

public class ECBlocks {
    private static final DeferredRegister<Block> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"elementalcraft");
    public static final DeferredHolder<Block, SmallElementContainerBlock> SMALL_CONTAINER = ECBlocks.register("small_container", () -> new SmallElementContainerBlock(ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, ElementContainerBlock> CONTAINER = ECBlocks.register("container", () -> new ElementContainerBlock(ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, ReservoirBlock> FIRE_RESERVOIR = ECBlocks.register("reservoir_fire", () -> new ReservoirBlock(ElementType.FIRE, ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, ReservoirBlock> WATER_RESERVOIR = ECBlocks.register("reservoir_water", () -> new ReservoirBlock(ElementType.WATER, ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, ReservoirBlock> EARTH_RESERVOIR = ECBlocks.register("reservoir_earth", () -> new ReservoirBlock(ElementType.EARTH, ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, ReservoirBlock> AIR_RESERVOIR = ECBlocks.register("reservoir_air", () -> new ReservoirBlock(ElementType.AIR, ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, CreativeElementContainerBlock> CREATIVE_CONTAINER = ECBlocks.register("creative_container", () -> new CreativeElementContainerBlock(ECProperties.Blocks.CONTAINER));
    public static final DeferredHolder<Block, RudimentaryElementExtractorBlock> RUDIMENTARY_EXTRACTOR = ECBlocks.registerDefault("rudimentary_element_extractor", RudimentaryElementExtractorBlock::new);
    public static final DeferredHolder<Block, ElementExtractorBlock> EXTRACTOR = ECBlocks.registerDefault("element_extractor", ElementExtractorBlock::new);
    public static final DeferredHolder<Block, ImprovedElementExtractorBlock> IMPROVED_EXTRACTOR = ECBlocks.registerDefault("improved_element_extractor", ImprovedElementExtractorBlock::new);
    public static final DeferredHolder<Block, CrackingSynthesizerBlock> CRACKING_SYNTHESIZER = ECBlocks.registerDefault("cracking_earth_synthesizer", CrackingSynthesizerBlock::new);
    public static final DeferredHolder<Block, CombustionSynthesizerBlock> COMBUSTION_SYNTHESIZER = ECBlocks.registerDefault("combustion_fire_synthesizer", CombustionSynthesizerBlock::new);
    public static final DeferredHolder<Block, DrainingSynthesizerBlock> DRAINING_SYNTHESIZER = ECBlocks.registerDefault("draining_water_synthesizer", DrainingSynthesizerBlock::new);
    public static final DeferredHolder<Block, VibrationSynthesizerBlock> VIBRATION_SYNTHESIZER = ECBlocks.registerDefault("vibration_air_synthesizer", VibrationSynthesizerBlock::new);
    public static final DeferredHolder<Block, SolarSynthesizerBlock> SOLAR_SYNTHESIZER = ECBlocks.registerDefault("solar_fire_synthesizer", SolarSynthesizerBlock::new);
    public static final DeferredHolder<Block, CulinarySynthesizerBlock> CULINARY_SYNTHESIZER = ECBlocks.registerDefault("culinary_water_synthesizer", CulinarySynthesizerBlock::new);
    public static final DeferredHolder<Block, SculkCrackingSynthesizerBlock> SCULK_CRACKING_SYNTHESIZER = ECBlocks.registerDefault("sculk_cracking_earth_synthesizer", SculkCrackingSynthesizerBlock::new);
    public static final DeferredHolder<Block, AirMillSynthesizerBlock> AIR_MILL_SYNTHESIZER = ECBlocks.registerDefault("air_mill_synthesizer", AirMillSynthesizerBlock::new);
    public static final DeferredHolder<Block, DiffuserBlock> DIFFUSER = ECBlocks.registerDefault("diffuser", DiffuserBlock::new);
    public static final DeferredHolder<Block, InfuserBlock> INFUSER = ECBlocks.registerDefault("infuser", InfuserBlock::new);
    public static final DeferredHolder<Block, BinderBlock> BINDER = ECBlocks.registerDefault("binder", BinderBlock::new);
    public static final DeferredHolder<Block, ImprovedBinderBlock> BINDER_IMPROVED = ECBlocks.registerDefault("binder_improved", ImprovedBinderBlock::new);
    public static final DeferredHolder<Block, CrystallizerBlock> CRYSTALLIZER = ECBlocks.registerDefault("crystallizer", CrystallizerBlock::new);
    public static final DeferredHolder<Block, InscriberBlock> INSCRIBER = ECBlocks.registerDefault("inscriber", InscriberBlock::new);
    public static final DeferredHolder<Block, WaterMillGrindstoneBlock> WATER_MILL_GRINDSTONE = ECBlocks.registerDefault("water_mill_grindstone", WaterMillGrindstoneBlock::new);
    public static final DeferredHolder<Block, AirMillGrindstoneBlock> AIR_MILL_GRINDSTONE = ECBlocks.registerDefault("air_mill_grindstone", AirMillGrindstoneBlock::new);
    public static final DeferredHolder<Block, WaterMillWoodSawBlock> WATER_MILL_WOOD_SAW = ECBlocks.registerDefault("water_mill_wood_saw", WaterMillWoodSawBlock::new);
    public static final DeferredHolder<Block, AirMillWoodSawBlock> AIR_MILL_WOOD_SAW = ECBlocks.registerDefault("air_mill_wood_saw", AirMillWoodSawBlock::new);
    public static final DeferredHolder<Block, EnchantmentLiquefierBlock> ENCHANTMENT_LIQUEFIER = ECBlocks.registerDefault("enchantment_liquefier", EnchantmentLiquefierBlock::new);
    public static final DeferredHolder<Block, PedestalBlock> FIRE_PEDESTAL = ECBlocks.register("pedestal_fire", () -> new PedestalBlock(ElementType.FIRE, ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES));
    public static final DeferredHolder<Block, PedestalBlock> WATER_PEDESTAL = ECBlocks.register("pedestal_water", () -> new PedestalBlock(ElementType.WATER, ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES));
    public static final DeferredHolder<Block, PedestalBlock> EARTH_PEDESTAL = ECBlocks.register("pedestal_earth", () -> new PedestalBlock(ElementType.EARTH, ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES));
    public static final DeferredHolder<Block, PedestalBlock> AIR_PEDESTAL = ECBlocks.register("pedestal_air", () -> new PedestalBlock(ElementType.AIR, ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES));
    public static final DeferredHolder<Block, PureInfuserBlock> PURE_INFUSER = ECBlocks.registerDefault("pure_infuser", PureInfuserBlock::new);
    public static final DeferredHolder<Block, FireFurnaceBlock> FIRE_FURNACE = ECBlocks.registerDefault("firefurnace", FireFurnaceBlock::new);
    public static final DeferredHolder<Block, FireBlastFurnaceBlock> FIRE_BLAST_FURNACE = ECBlocks.registerDefault("fireblastfurnace", FireBlastFurnaceBlock::new);
    public static final DeferredHolder<Block, PurifierBlock> PURIFIER = ECBlocks.registerDefault("purifier", PurifierBlock::new);
    public static final DeferredHolder<Block, ElementPipeBlock> PIPE_RUDIMENTARY = ECBlocks.register("elementpipe_rudimentary", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.RUDIMENTARY, ECProperties.Blocks.PIPE));
    public static final DeferredHolder<Block, ElementPipeBlock> PIPE = ECBlocks.register("elementpipe", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.STANDARD, ECProperties.Blocks.PIPE));
    public static final DeferredHolder<Block, ElementPipeBlock> PIPE_IMPROVED = ECBlocks.register("elementpipe_improved", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.IMPROVED, ECProperties.Blocks.PIPE));
    public static final DeferredHolder<Block, ElementPipeBlock> PIPE_CREATIVE = ECBlocks.register("elementpipe_creative", () -> new ElementPipeBlock(ElementPipeBlock.PipeType.CREATIVE, ECProperties.Blocks.PIPE));
    public static final DeferredHolder<Block, RetrieverBlock> RETRIEVER = ECBlocks.registerDefault("instrument_retriever", RetrieverBlock::new);
    public static final DeferredHolder<Block, SorterBlock> SORTER = ECBlocks.registerNoOcclusion("sorter", SorterBlock::new);
    public static final DeferredHolder<Block, SpellDeskBlock> SPELL_DESK = ECBlocks.registerDefault("spell_desk", SpellDeskBlock::new);
    public static final DeferredHolder<Block, FirePylonBlock> FIRE_PYLON = ECBlocks.registerNoOcclusion("firepylon", FirePylonBlock::new);
    public static final DeferredHolder<Block, VacuumShrineBlock> VACUUM_SHRINE = ECBlocks.registerNoOcclusion("vacuumshrine", VacuumShrineBlock::new);
    public static final DeferredHolder<Block, GrowthShrineBlock> GROWTH_SHRINE = ECBlocks.registerNoOcclusion("growthshrine", GrowthShrineBlock::new);
    public static final DeferredHolder<Block, HarvestShrineBlock> HARVEST_SHRINE = ECBlocks.registerNoOcclusion("harvestshrine", HarvestShrineBlock::new);
    public static final DeferredHolder<Block, LumberShrineBlock> LUMBER_SHRINE = ECBlocks.registerNoOcclusion("lumbershrine", LumberShrineBlock::new);
    public static final DeferredHolder<Block, MeltingShrineBlock> MELTING_SHRINE = ECBlocks.registerNoOcclusion("melting_shrine", MeltingShrineBlock::new);
    public static final DeferredHolder<Block, OreShrineBlock> ORE_SHRINE = ECBlocks.registerNoOcclusion("oreshrine", OreShrineBlock::new);
    public static final DeferredHolder<Block, OverloadShrineBlock> OVERLOAD_SHRINE = ECBlocks.registerNoOcclusion("overloadshrine", OverloadShrineBlock::new);
    public static final DeferredHolder<Block, SweetShrineBlock> SWEET_SHRINE = ECBlocks.registerNoOcclusion("sweetshrine", SweetShrineBlock::new);
    public static final DeferredHolder<Block, EnderLockShrineBlock> ENDER_LOCK_SHRINE = ECBlocks.registerNoOcclusion("enderlockshrine", EnderLockShrineBlock::new);
    public static final DeferredHolder<Block, BreedingShrineBlock> BREEDING_SHRINE = ECBlocks.registerNoOcclusion("breedingshrine", BreedingShrineBlock::new);
    public static final DeferredHolder<Block, GroveShrineBlock> GROVE_SHRINE = ECBlocks.registerNoOcclusion("groveshrine", GroveShrineBlock::new);
    public static final DeferredHolder<Block, SpringShrineBlock> SPRING_SHRINE = ECBlocks.registerNoOcclusion("springshrine", SpringShrineBlock::new);
    public static final DeferredHolder<Block, BuddingShrineBlock> BUDDING_SHRINE = ECBlocks.registerNoOcclusion("buddingshrine", BuddingShrineBlock::new);
    public static final DeferredHolder<Block, SpawningShrineBlock> SPAWNING_SHRINE = ECBlocks.registerNoOcclusion("spawningshrine", SpawningShrineBlock::new);
    public static final DeferredHolder<Block, AccelerationShrineUpgradeBlock> ACCELERATION_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_acceleration", AccelerationShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, OverclockedAccelerationShrineUpgradeBlock> OVERCLOCKED_ACCELERATION_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_overclocked_acceleration", OverclockedAccelerationShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, RangeShrineUpgradeBlock> RANGE_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_range", RangeShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, CapacityShrineUpgradeBlock> CAPACITY_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_capacity", CapacityShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, EfficiencyShrineUpgradeBlock> EFFICIENCY_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_efficiency", EfficiencyShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, StrengthShrineUpgradeBlock> STRENGTH_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_strength", StrengthShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, OverwhelmingStrengthShrineUpgradeBlock> OVERWHELMING_STRENGTH_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_overwhelming_strength", OverwhelmingStrengthShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, OptimizationShrineUpgradeBlock> OPTIMIZATION_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_optimization", OptimizationShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, FortuneShrineUpgradeBlock> FORTUNE_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_fortune", FortuneShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, GreaterFortuneShrineUpgradeBlock> GREATER_FORTUNE_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_greater_fortune", GreaterFortuneShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, SilkTouchShrineUpgradeBlock> SILK_TOUCH_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_silk_touch", SilkTouchShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, PlantingShrineUpgradeBlock> PLANTING_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_planting", PlantingShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, BonelessGrowthShrineUpgradeBlock> BONELESS_GROWTH_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_boneless_growth", BonelessGrowthShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, PickupShrineUpgradeBlock> PICKUP_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_pickup", PickupShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, VortexShrineUpgradeBlock> VORTEX_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_vortex", VortexShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, NectarShrineUpgradeBlock> NECTAR_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_nectar", NectarShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, MysticalGroveShrineUpgradeBlock> MYSTICAL_GROVE_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_mystical_grove", MysticalGroveShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, StemPollinationShrineUpgradeBlock> STEM_POLLINATION_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_stem_pollination", StemPollinationShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, ProtectionShrineUpgradeBlock> PROTECTION_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_protection", ProtectionShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, FillingShrineUpgradeBlock> FILLING_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_filling", FillingShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, SpringalineShrineUpgradeBlock> SPRINGALINE_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_springaline", SpringalineShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, CrystalHarvestShrineUpgradeBlock> CRYSTAL_HARVEST_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_crystal_harvest", CrystalHarvestShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, CrystalGrowthShrineUpgradeBlock> CRYSTAL_GROWTH_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_crystal_growth", CrystalGrowthShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, TranslocationShrineUpgradeBlock> TRANSLOCATION_SHRINE_UPGRADE = ECBlocks.registerNoOcclusion("shrine_upgrade_translocation", TranslocationShrineUpgradeBlock::new);
    public static final DeferredHolder<Block, SourceBlock> FIRE_SOURCE = ECBlocks.register("fire_source", () -> new SourceBlock(ElementType.FIRE, ECProperties.Blocks.SOURCE));
    public static final DeferredHolder<Block, SourceBlock> WATER_SOURCE = ECBlocks.register("water_source", () -> new SourceBlock(ElementType.WATER, ECProperties.Blocks.SOURCE));
    public static final DeferredHolder<Block, SourceBlock> EARTH_SOURCE = ECBlocks.register("earth_source", () -> new SourceBlock(ElementType.EARTH, ECProperties.Blocks.SOURCE));
    public static final DeferredHolder<Block, SourceBlock> AIR_SOURCE = ECBlocks.register("air_source", () -> new SourceBlock(ElementType.AIR, ECProperties.Blocks.SOURCE));
    public static final DeferredHolder<Block, SourceBreederBlock> SOURCE_BREEDER = ECBlocks.registerDefault("source_breeder", SourceBreederBlock::new);
    public static final DeferredHolder<Block, SourceBreederPedestalBlock> SOURCE_BREEDER_PEDESTAL = ECBlocks.registerNoOcclusion("source_breeder_pedestal", SourceBreederPedestalBlock::new);
    public static final DeferredHolder<Block, TranslocationAnchorBlock> TRANSLOCATION_ANCHOR = ECBlocks.registerDefault("translocation_anchor", TranslocationAnchorBlock::new);
    public static final DeferredHolder<Block, DropExperienceBlock> CRYSTAL_ORE = ECBlocks.register("inert_crystal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE)));
    public static final DeferredHolder<Block, DropExperienceBlock> DEEPSLATE_CRYSTAL_ORE = ECBlocks.register("deepslate_inert_crystal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE)));
    public static final DeferredHolder<Block, Block> WHITE_ROCK = ECBlocks.registerSimple("whiterock", ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, SlabBlock> WHITE_ROCK_SLAB = ECBlocks.registerSlab(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, StairBlock> WHITE_ROCK_STAIRS = ECBlocks.registerStairs(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, WallBlock> WHITE_ROCK_WALL = ECBlocks.registerWall(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, FenceBlock> WHITE_ROCK_FENCE = ECBlocks.registerFence(WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, Block> WHITE_ROCK_BRICK = ECBlocks.registerSimple("whiterock_brick", ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, SlabBlock> WHITE_ROCK_BRICK_SLAB = ECBlocks.registerSlab(WHITE_ROCK_BRICK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, StairBlock> WHITE_ROCK_BRICK_STAIRS = ECBlocks.registerStairs(WHITE_ROCK_BRICK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, WallBlock> WHITE_ROCK_BRICK_WALL = ECBlocks.registerWall(WHITE_ROCK_BRICK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, Block> MOSSY_WHITE_ROCK = ECBlocks.registerSimple("whiterock_mossy", ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, SlabBlock> MOSSY_WHITE_ROCK_SLAB = ECBlocks.registerSlab(MOSSY_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, StairBlock> MOSSY_WHITE_ROCK_STAIRS = ECBlocks.registerStairs(MOSSY_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, WallBlock> MOSSY_WHITE_ROCK_WALL = ECBlocks.registerWall(MOSSY_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, Block> BURNT_WHITE_ROCK = ECBlocks.registerSimple("whiterock_burnt", ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, SlabBlock> BURNT_WHITE_ROCK_SLAB = ECBlocks.registerSlab(BURNT_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, StairBlock> BURNT_WHITE_ROCK_STAIRS = ECBlocks.registerStairs(BURNT_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, WallBlock> BURNT_WHITE_ROCK_WALL = ECBlocks.registerWall(BURNT_WHITE_ROCK, ECProperties.Blocks.WHITEROCK);
    public static final DeferredHolder<Block, Block> PURE_ROCK = ECBlocks.registerSimple("purerock", ECProperties.Blocks.PUREROCK);
    public static final DeferredHolder<Block, SlabBlock> PURE_ROCK_SLAB = ECBlocks.registerSlab(PURE_ROCK, ECProperties.Blocks.PUREROCK);
    public static final DeferredHolder<Block, StairBlock> PURE_ROCK_STAIRS = ECBlocks.registerStairs(PURE_ROCK, ECProperties.Blocks.PUREROCK);
    public static final DeferredHolder<Block, WallBlock> PURE_ROCK_WALL = ECBlocks.registerWall(PURE_ROCK, ECProperties.Blocks.PUREROCK);
    public static final DeferredHolder<Block, TransparentBlock> BURNT_GLASS = ECBlocks.registerGlass("burnt_glass");
    public static final DeferredHolder<Block, IronBarsBlock> BURNT_GLASS_PANE = ECBlocks.registerGlassPane(BURNT_GLASS);
    public static final DeferredHolder<Block, Block> DRENCHED_IRON_BLOCK = ECBlocks.registerSimple("drenched_iron_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final DeferredHolder<Block, Block> SWIFT_ALLOY_BLOCK = ECBlocks.registerSimple("swift_alloy_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK));
    public static final DeferredHolder<Block, Block> FIREITE_BLOCK = ECBlocks.registerSimple("fireite_block", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK));
    public static final DeferredHolder<Block, Block> INERT_CRYSTAL_BLOCK = ECBlocks.registerSimple("inert_crystal_block");
    public static final DeferredHolder<Block, Block> FIRE_CRYSTAL_BLOCK = ECBlocks.registerSimple("firecrystal_block");
    public static final DeferredHolder<Block, Block> WATER_CRYSTAL_BLOCK = ECBlocks.registerSimple("watercrystal_block");
    public static final DeferredHolder<Block, Block> EARTH_CRYSTAL_BLOCK = ECBlocks.registerSimple("earthcrystal_block");
    public static final DeferredHolder<Block, Block> AIR_CRYSTAL_BLOCK = ECBlocks.registerSimple("aircrystal_block");
    public static final DeferredHolder<Block, AmethystBlock> SPRINGALINE_BLOCK = ECBlocks.register("springaline_block", () -> new AmethystBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK)));
    public static final DeferredHolder<Block, AmethystClusterBlock> SPRINGALINE_CLUSTER = ECBlocks.register("springaline_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER)));
    public static final DeferredHolder<Block, AmethystClusterBlock> LARGE_SPRINGALINE_BUD = ECBlocks.register("large_springaline_bud", () -> new AmethystClusterBlock(5.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_AMETHYST_BUD)));
    public static final DeferredHolder<Block, AmethystClusterBlock> MEDIUM_SPRINGALINE_BUD = ECBlocks.register("medium_springaline_bud", () -> new AmethystClusterBlock(4.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MEDIUM_AMETHYST_BUD)));
    public static final DeferredHolder<Block, AmethystClusterBlock> SMALL_SPRINGALINE_BUD = ECBlocks.register("small_springaline_bud", () -> new AmethystClusterBlock(3.0f, 4.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMALL_AMETHYST_BUD)));
    public static final DeferredHolder<Block, TransparentBlock> SPRINGALINE_GLASS = ECBlocks.registerGlass("springaline_glass");
    public static final DeferredHolder<Block, IronBarsBlock> SPRINGALINE_GLASS_PANE = ECBlocks.registerGlassPane(SPRINGALINE_GLASS);
    public static final DeferredHolder<Block, Block> SPRINGALINE_LANTERN = ECBlocks.register("springaline_lantern", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN)));

    private ECBlocks() {
    }

    private static <T extends Block> DeferredHolder<Block, T> register(String name, Supplier<T> block) {
        return DEFERRED_REGISTER.register(name, block);
    }

    private static <T extends Block> DeferredHolder<Block, T> registerDefault(String name, Function<BlockBehaviour.Properties, T> block) {
        return ECBlocks.register(name, () -> (Block)block.apply(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES));
    }

    private static <T extends Block> DeferredHolder<Block, T> registerNoOcclusion(String name, Function<BlockBehaviour.Properties, T> block) {
        return ECBlocks.register(name, () -> (Block)block.apply(ECProperties.Blocks.DEFAULT_NO_OCCLUSION));
    }

    private static DeferredHolder<Block, Block> registerSimple(String name, BlockBehaviour.Properties properties) {
        return ECBlocks.register(name, () -> new Block(properties));
    }

    private static DeferredHolder<Block, Block> registerSimple(String name) {
        return ECBlocks.registerSimple(name, ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES);
    }

    private static <T extends Block> DeferredHolder<Block, SlabBlock> registerSlab(DeferredHolder<Block, T> block, BlockBehaviour.Properties properties) {
        return ECBlocks.register(block.getId().getPath() + "_slab", () -> new SlabBlock(properties));
    }

    private static <T extends Block> DeferredHolder<Block, StairBlock> registerStairs(DeferredHolder<Block, T> block, BlockBehaviour.Properties properties) {
        return ECBlocks.register(block.getId().getPath() + "_stairs", () -> new StairBlock(((Block)block.get()).defaultBlockState(), properties));
    }

    private static <T extends Block> DeferredHolder<Block, WallBlock> registerWall(DeferredHolder<Block, T> block, BlockBehaviour.Properties properties) {
        return ECBlocks.register(block.getId().getPath() + "_wall", () -> new WallBlock(properties));
    }

    private static <T extends Block> DeferredHolder<Block, FenceBlock> registerFence(DeferredHolder<Block, T> block, BlockBehaviour.Properties properties) {
        return ECBlocks.register(block.getId().getPath() + "_fence", () -> new FenceBlock(properties));
    }

    private static DeferredHolder<Block, TransparentBlock> registerGlass(String name) {
        return ECBlocks.register(name, () -> new TransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    }

    private static DeferredHolder<Block, IronBarsBlock> registerGlassPane(DeferredHolder<Block, ? extends TransparentBlock> block) {
        return ECBlocks.register(block.getId().getPath() + "_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    }

    public static void register(IEventBus bus) {
        ECBlocks.registerAliases(DEFERRED_REGISTER);
        DEFERRED_REGISTER.register(bus);
    }

    public static void registerAliases(DeferredRegister<?> register) {
        register.addAlias(ElementalCraftApi.createRL("extractor"), ElementalCraftApi.createRL("rudimentary_element_extractor"));
        register.addAlias(ElementalCraftApi.createRL("extractor_improved"), ElementalCraftApi.createRL("improved_element_extractor"));
        register.addAlias(ElementalCraftApi.createRL("elementpipe_impaired"), ElementalCraftApi.createRL("elementpipe_rudimentary"));
        register.addAlias(ElementalCraftApi.createRL("solar_synthesizer"), ElementalCraftApi.createRL("solar_fire_synthesizer"));
        register.addAlias(ElementalCraftApi.createRL("pureinfuser"), ElementalCraftApi.createRL("pure_infuser"));
        register.addAlias(ElementalCraftApi.createRL("lavashrine"), ElementalCraftApi.createRL("melting_shrine"));
    }
}

