/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.upgrade;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.common.util.Lazy;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public abstract class AbstractUpgrade<T> {
    private ResourceLocation id;
    private IBlockPosPredicate predicate;
    protected int maxAmount;
    protected final Map<T, Float> bonuses;
    private Lazy<List<Component>> predicateTooltip;

    protected AbstractUpgrade(IBlockPosPredicate predicate, Map<T, Float> map, int maxAmount) {
        this.setPredicate(predicate);
        this.bonuses = map;
        this.maxAmount = maxAmount;
        this.id = null;
    }

    protected static <T extends StringRepresentable, U extends AbstractUpgrade<T>> Products.P3<RecordCodecBuilder.Mu<U>, IBlockPosPredicate, Map<T, Float>, Integer> codec(RecordCodecBuilder.Instance<U> builder, Codec<T> bonusCodec) {
        return builder.group((App)IBlockPosPredicate.CODEC.fieldOf("predicate").forGetter(AbstractUpgrade::getPredicate), (App)Codec.unboundedMap(bonusCodec, (Codec)Codec.FLOAT).optionalFieldOf("bonuses", Map.of()).forGetter(AbstractUpgrade::getBonuses), (App)Codec.INT.optionalFieldOf("max_amount", (Object)0).forGetter(u -> u.maxAmount));
    }

    protected boolean canUpgrade(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction, int amount) {
        return (this.maxAmount == 0 || amount < this.maxAmount) && this.predicate.test(level, pos, direction);
    }

    protected void merge(AbstractUpgrade<T> other) {
        this.setPredicate(this.predicate.or(new IBlockPosPredicate[]{other.predicate}));
        other.bonuses.forEach((bonus, value) -> {
            if (this.bonuses.containsKey(bonus)) {
                this.bonuses.put(bonus, Float.valueOf(this.bonuses.get(bonus).floatValue() * value.floatValue()));
            } else {
                this.bonuses.put((T)bonus, (Float)value);
            }
        });
        if (this.maxAmount == 0) {
            this.maxAmount = other.maxAmount;
        }
    }

    public final Map<T, Float> getBonuses() {
        return this.bonuses;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IBlockPosPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(IBlockPosPredicate predicate) {
        this.predicate = predicate.simplify();
        this.predicateTooltip = Lazy.of(() -> ((IBlockPosPredicate)predicate).getTooltip());
    }

    public List<Component> getPredicateTooltip() {
        return (List)this.predicateTooltip.get();
    }

    public final void setId(ResourceLocation id) {
        this.id = id;
    }

    public String toString() {
        return this.id != null ? this.id.toString() : super.toString();
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractUpgrade && this.id != null) {
            return this.id.equals((Object)((AbstractUpgrade)other).id);
        }
        return super.equals(other);
    }
}

