/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.value;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProviderBuilder;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderTypes;

public class StepsSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "steps";
    public static final MapCodec<StepsSourceTraitValueProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Step.CODEC.listOf().fieldOf(NAME).forGetter(p -> p.steps)).apply((Applicative)builder, StepsSourceTraitValueProvider::new));
    private final List<Step> steps;
    private final Codec<ISourceTraitValue> valueCodec;
    private final StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec;

    public static Builder builder() {
        return new Builder();
    }

    private StepsSourceTraitValueProvider(Collection<Step> steps) {
        this.steps = ImmutableList.copyOf(steps);
        this.valueCodec = Codec.INT.xmap(this.steps::get, this.steps::indexOf);
        this.valueStreamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, this.steps::indexOf, this.steps::get);
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        return this.roll(context.random(), context.luck(), this.steps.stream().filter(s -> s.predicate().test((LevelReader)level, pos, null)).toList());
    }

    @Override
    @Nullable
    public ISourceTraitValue breed(SourceTraitRollContext context, @Nullable ISourceTraitValue value1, @Nullable ISourceTraitValue value2) {
        RandomSource random = context.random();
        float luck = context.luck();
        if (value1 instanceof Step) {
            Step step1 = (Step)value1;
            if (value2 instanceof Step) {
                Step step2 = (Step)value2;
                int b1 = step1.breedIndex();
                int b2 = step2.breedIndex();
                return this.createStep(random, luck, this.getMin(b1, b2), this.getMax(b1, b2));
            }
        }
        if (value1 instanceof Step) {
            Step step = (Step)value1;
            return this.createStep(random, luck, step);
        }
        if (value2 instanceof Step) {
            Step step = (Step)value2;
            return this.createStep(random, luck, step);
        }
        return this.createStep(random, luck, -1, 1);
    }

    private int getMin(int b1, int b2) {
        int min = Math.min(b1, b2) - 1;
        if (this.steps.stream().anyMatch(s -> s.breedIndex() == min)) {
            return min;
        }
        return min - 1;
    }

    private int getMax(int b1, int b2) {
        int max = Math.max(b1, b2) + 1;
        if (this.steps.stream().anyMatch(s -> s.breedIndex() == max)) {
            return max;
        }
        return max + 1;
    }

    @Nullable
    private Step createStep(RandomSource random, float luck, Step step) {
        int index = step.breedIndex();
        return this.createStep(random, luck, index - 1, index + 1);
    }

    @Nullable
    private Step createStep(RandomSource random, float luck, int min, int max) {
        return this.roll(random, luck, this.steps.stream().filter(s -> s.breedIndex() >= min && s.breedIndex() <= max).toList());
    }

    @Nullable
    private Step roll(RandomSource random, float luck, List<Step> list) {
        int bound = list.stream().mapToInt(s -> s.weight(luck)).sum();
        if (bound <= 0) {
            return null;
        }
        int roll = random.nextInt(bound);
        if (roll <= 0) {
            return null;
        }
        for (Step step : list) {
            if ((roll -= step.weight(luck)) >= 0) continue;
            return step;
        }
        return null;
    }

    @Nonnull
    public SourceTraitValueProviderType<StepsSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.STEPS.get();
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        IntTag intTag;
        return tag instanceof IntTag && (intTag = (IntTag)tag).getAsInt() >= 0 && intTag.getAsInt() < this.steps.size() ? (ISourceTraitValue)this.steps.get(intTag.getAsInt()) : null;
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        IntTag intTag;
        if (value instanceof Step) {
            Step step = (Step)value;
            intTag = IntTag.valueOf((int)this.steps.indexOf(step));
        } else {
            intTag = null;
        }
        return intTag;
    }

    @Override
    public Codec<ISourceTraitValue> valueCodec() {
        return this.valueCodec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec() {
        return this.valueStreamCodec;
    }

    public static class Builder
    implements ISourceTraitValueProviderBuilder {
        private final List<Step> steps = new ArrayList<Step>();

        private Builder() {
        }

        public Builder step(String translationKey, int weight, Map<SourceTrait.Type, Float> values, int breedIndex) {
            return this.step(translationKey, weight, values, breedIndex, IBlockPosPredicate.any());
        }

        public Builder step(String translationKey, int weight, float luckRatio, Map<SourceTrait.Type, Float> values, int breedIndex) {
            return this.step(translationKey, weight, luckRatio, values, breedIndex, IBlockPosPredicate.any());
        }

        public Builder step(String translationKey, int weight, Map<SourceTrait.Type, Float> values, int breedIndex, IBlockPosPredicate predicate) {
            return this.step(translationKey, weight, 1.0f, values, breedIndex, predicate);
        }

        public Builder step(String translationKey, int weight, float luckRatio, Map<SourceTrait.Type, Float> values, int breedIndex, IBlockPosPredicate predicate) {
            this.steps.add(new Step(translationKey, weight, luckRatio, values, breedIndex, predicate));
            return this;
        }

        @Override
        public StepsSourceTraitValueProvider build() {
            return new StepsSourceTraitValueProvider(this.steps);
        }
    }

    private record Step(String translationKey, int weight, float luckRatio, Map<SourceTrait.Type, Float> values, int breedIndex, IBlockPosPredicate predicate) implements ISourceTraitValue
    {
        public static final Codec<Step> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(Step::translationKey), (App)Codec.INT.fieldOf("weight").forGetter(Step::weight), (App)Codec.FLOAT.optionalFieldOf("luck_ratio", (Object)Float.valueOf(1.0f)).forGetter(Step::luckRatio), (App)SourceTrait.Type.VALUE_CODEC.fieldOf("values").forGetter(Step::values), (App)Codec.INT.fieldOf("breed_index").forGetter(Step::breedIndex), (App)IBlockPosPredicate.CODEC.optionalFieldOf("predicate", (Object)IBlockPosPredicate.any()).forGetter(Step::predicate)).apply((Applicative)builder, Step::new));

        @Override
        public float getValue(SourceTrait.Type type) {
            return this.values.getOrDefault((Object)type, Float.valueOf(1.0f)).floatValue();
        }

        @Override
        public Component getDescription() {
            return Component.translatable((String)this.translationKey);
        }

        public int weight(float luck) {
            return Math.max(0, Math.round((float)this.weight + this.luckRatio * luck));
        }
    }
}

