/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.LinearSourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderTypes;

public class RangeBasedSourceTraitValueProvider
extends LinearSourceTraitValueProvider {
    public static final String NAME = "range_based";
    public static final MapCodec<RangeBasedSourceTraitValueProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> RangeBasedSourceTraitValueProvider.codec(builder).and((App)Codec.FLOAT.fieldOf("weight").forGetter(p -> Float.valueOf(p.weight))).apply((Applicative)builder, RangeBasedSourceTraitValueProvider::new));
    private final float weight;

    public RangeBasedSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float end, float weight) {
        this(translationKey, types, 0.0f, end, weight);
    }

    public RangeBasedSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float start, float end, float weight) {
        this(translationKey, types, start, end, 1.0f, weight);
    }

    public RangeBasedSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float start, float end, float luckRatio, float weight) {
        super(translationKey, types, start, end, luckRatio);
        this.weight = weight;
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        BlockPos blockPos;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockPos = serverLevel.getSharedSpawnPos();
        } else {
            blockPos = BlockPos.ZERO;
        }
        BlockPos spawn = blockPos;
        double rangeSq = new BlockPos(spawn.getX(), 0, spawn.getZ()).distSqr((Vec3i)new BlockPos(pos.getX(), 0, pos.getZ()));
        float newStart = Math.min(this.start + context.luck() * this.luckRatio, this.end);
        return this.createValue(newStart + (float)(rangeSq / (rangeSq + (double)(context.random().nextFloat() * this.weight * this.weight))) * (this.end - newStart));
    }

    @Nonnull
    public SourceTraitValueProviderType<RangeBasedSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.RANGE_BASED.get();
    }
}

