/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderTypes;

public class PredicateSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "predicate";
    public static final MapCodec<PredicateSourceTraitValueProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ISourceTraitValueProvider.CODEC.fieldOf("provider").forGetter(p -> p.provider), (App)IBlockPosPredicate.CODEC.fieldOf(NAME).forGetter(p -> p.predicate)).apply((Applicative)builder, PredicateSourceTraitValueProvider::new));
    private final ISourceTraitValueProvider provider;
    private final IBlockPosPredicate predicate;

    public PredicateSourceTraitValueProvider(ISourceTraitValueProvider provider, IBlockPosPredicate predicate) {
        this.provider = provider;
        this.predicate = predicate;
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        if (this.predicate.test((LevelReader)level, pos, null)) {
            return this.provider.roll(context, level, pos);
        }
        return null;
    }

    @Override
    @Nullable
    public ISourceTraitValue breed(SourceTraitRollContext context, @Nullable ISourceTraitValue value1, @Nullable ISourceTraitValue value2) {
        return this.provider.breed(context, value1, value2);
    }

    @NotNull
    public SourceTraitValueProviderType<PredicateSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.PREDICATE.get();
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        return this.provider.load(tag);
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        return this.provider.save(value);
    }

    @Override
    public Codec<ISourceTraitValue> valueCodec() {
        return this.provider.valueCodec();
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec() {
        return this.provider.valueStreamCodec();
    }
}

