/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.value;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderTypes;

public class LinearSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "linear";
    public static final MapCodec<LinearSourceTraitValueProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> LinearSourceTraitValueProvider.codec(builder).apply((Applicative)builder, LinearSourceTraitValueProvider::new));
    protected final String translationKey;
    protected final float start;
    protected final float end;
    protected final float luckRatio;
    protected final List<SourceTrait.Type> types;
    private final Codec<ISourceTraitValue> valueCodec;
    private final StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec;

    public LinearSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float end) {
        this(translationKey, types, 0.0f, end);
    }

    public LinearSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float start, float end) {
        this(translationKey, types, start, end, 1.0f);
    }

    public LinearSourceTraitValueProvider(String translationKey, List<SourceTrait.Type> types, float start, float end, float luckRatio) {
        this.translationKey = translationKey;
        this.start = start;
        this.end = end;
        this.types = types;
        this.luckRatio = luckRatio;
        this.valueCodec = Codec.FLOAT.xmap(this::createValue, t -> Float.valueOf(((SourceTraitValue)t).value));
        this.valueStreamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(((SourceTraitValue)t).value), this::createValue);
    }

    protected static <T extends LinearSourceTraitValueProvider> Products.P5<RecordCodecBuilder.Mu<T>, String, List<SourceTrait.Type>, Float, Float, Float> codec(RecordCodecBuilder.Instance<T> builder) {
        return builder.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.translationKey), (App)SourceTrait.Type.CODEC.listOf().fieldOf("bonus_type").forGetter(LinearSourceTraitValueProvider::getTypes), (App)Codec.FLOAT.optionalFieldOf("start", (Object)Float.valueOf(0.0f)).forGetter(LinearSourceTraitValueProvider::getStart), (App)Codec.FLOAT.fieldOf("end").forGetter(LinearSourceTraitValueProvider::getEnd), (App)Codec.FLOAT.fieldOf("luck_ratio").forGetter(LinearSourceTraitValueProvider::getLuckRatio));
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.end;
    }

    private float getLuckRatio() {
        return this.luckRatio;
    }

    private List<SourceTrait.Type> getTypes() {
        return this.types;
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        return this.createValue(this.start, this.end, context.random(), context.luck());
    }

    @Override
    @Nullable
    public ISourceTraitValue breed(SourceTraitRollContext context, @Nullable ISourceTraitValue value1, @Nullable ISourceTraitValue value2) {
        RandomSource random = context.random();
        float luck = context.luck();
        if (value1 instanceof SourceTraitValue) {
            SourceTraitValue v1 = (SourceTraitValue)value1;
            if (value2 instanceof SourceTraitValue) {
                SourceTraitValue v2 = (SourceTraitValue)value2;
                return this.createValue(this.getBreedingStart(Math.min(v1.value, v2.value)), this.getBreedingEnd(Math.max(v1.value, v2.value)), random, luck);
            }
        }
        if (value1 instanceof SourceTraitValue) {
            SourceTraitValue v1 = (SourceTraitValue)value1;
            return this.createValue(v1.value, random, luck);
        }
        if (value2 instanceof SourceTraitValue) {
            SourceTraitValue v2 = (SourceTraitValue)value2;
            return this.createValue(v2.value, random, luck);
        }
        return this.createValue(this.start, this.end, random, luck);
    }

    private ISourceTraitValue createValue(float value, RandomSource random, float luck) {
        return this.createValue(this.roll(this.getBreedingStart(this.start), value, random, luck), this.roll(value, this.getBreedingStart(this.end), random, luck), random, luck);
    }

    private float getBreedingStart(float value) {
        return Math.max(this.start * 0.8f, value * 0.8f);
    }

    private float getBreedingEnd(float value) {
        return Math.min(this.end * 1.2f, value * 1.2f);
    }

    private ISourceTraitValue createValue(float s, float e, RandomSource rand, float luck) {
        return this.createValue(this.roll(s, e, rand, luck));
    }

    private float roll(float s, float e, RandomSource rand, float luck) {
        return this.roll(Math.min(s + luck * this.luckRatio, e), e, rand);
    }

    private float roll(float s, float e, RandomSource rand) {
        if (s > e) {
            return this.roll(e, s, rand);
        }
        return s + rand.nextFloat() * (e - s);
    }

    @Nonnull
    public SourceTraitValueProviderType<? extends LinearSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.LINEAR.get();
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        ISourceTraitValue iSourceTraitValue;
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            iSourceTraitValue = this.createValue(floatTag.getAsFloat());
        } else {
            iSourceTraitValue = null;
        }
        return iSourceTraitValue;
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        FloatTag floatTag;
        if (value instanceof SourceTraitValue) {
            SourceTraitValue sourceTraitValue = (SourceTraitValue)value;
            floatTag = FloatTag.valueOf((float)sourceTraitValue.value);
        } else {
            floatTag = null;
        }
        return floatTag;
    }

    @Override
    public Codec<ISourceTraitValue> valueCodec() {
        return this.valueCodec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec() {
        return this.valueStreamCodec;
    }

    protected ISourceTraitValue createValue(float value) {
        return new SourceTraitValue(value);
    }

    private class SourceTraitValue
    implements ISourceTraitValue {
        private final float value;

        private SourceTraitValue(float value) {
            this.value = value;
        }

        @Override
        public float getValue(SourceTrait.Type type) {
            if (LinearSourceTraitValueProvider.this.types.contains((Object)type)) {
                return this.value;
            }
            return 1.0f;
        }

        public float getRatio() {
            float e = LinearSourceTraitValueProvider.this.end - LinearSourceTraitValueProvider.this.start;
            if (e == 0.0f) {
                return 0.0f;
            }
            return (this.value - LinearSourceTraitValueProvider.this.start) / e;
        }

        @Override
        public Component getDescription() {
            float ratio = this.getRatio();
            return Component.translatable((String)"source_trait.elementalcraft.linear", (Object[])new Object[]{Component.translatable((String)LinearSourceTraitValueProvider.this.translationKey), Math.round(ratio * 100.0f)}).withStyle(this.getFormatting(ratio));
        }

        private ChatFormatting getFormatting(float ratio) {
            if (ratio < 0.25f) {
                return ChatFormatting.RED;
            }
            if (ratio < 0.5f) {
                return ChatFormatting.YELLOW;
            }
            return ChatFormatting.GREEN;
        }
    }
}

