/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderTypes;

public final class FixedSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "fixed";
    public static final MapCodec<FixedSourceTraitValueProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(FixedSourceTraitValueProvider::getTranslationKey), (App)SourceTrait.Type.VALUE_CODEC.fieldOf("values").forGetter(FixedSourceTraitValueProvider::getValues)).apply((Applicative)builder, FixedSourceTraitValueProvider::new));
    private final String translationKey;
    private final Map<SourceTrait.Type, Float> values;
    private final SourceTraitValue value;

    public FixedSourceTraitValueProvider(String translationKey, Map<SourceTrait.Type, Float> values) {
        this.translationKey = translationKey;
        this.values = values;
        this.value = new SourceTraitValue();
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        return this.value;
    }

    @Override
    public ISourceTraitValue breed(SourceTraitRollContext context, @Nullable ISourceTraitValue value1, @Nullable ISourceTraitValue value2) {
        return this.value;
    }

    @NotNull
    public SourceTraitValueProviderType<FixedSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.FIXED.get();
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        return this.value;
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        return ByteTag.ONE;
    }

    @Override
    public Codec<ISourceTraitValue> valueCodec() {
        return Codec.unit((Object)this.value);
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec() {
        return StreamCodec.unit((Object)this.value);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public Map<SourceTrait.Type, Float> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FixedSourceTraitValueProvider that = (FixedSourceTraitValueProvider)obj;
        return Objects.equals(this.translationKey, that.translationKey) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.translationKey, this.values);
    }

    public String toString() {
        return "FixedSourceTraitValueProvider[translationKey=" + this.translationKey + ", values=" + String.valueOf(this.values) + "]";
    }

    private class SourceTraitValue
    implements ISourceTraitValue {
        private SourceTraitValue() {
        }

        @Override
        public float getValue(SourceTrait.Type type) {
            return FixedSourceTraitValueProvider.this.values.getOrDefault((Object)type, Float.valueOf(1.0f)).floatValue();
        }

        @Override
        public Component getDescription() {
            return Component.translatable((String)FixedSourceTraitValueProvider.this.translationKey);
        }
    }
}

