/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderType;
import sirttas.elementalcraft.api.source.trait.value.SourceTraitValueProviderTypes;

public class ChanceSourceTraitValueProvider
implements ISourceTraitValueProvider {
    public static final String NAME = "chance";
    public static final MapCodec<ChanceSourceTraitValueProvider> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ISourceTraitValueProvider.CODEC.fieldOf("provider").forGetter(p -> p.provider), (App)Codec.FLOAT.fieldOf(NAME).forGetter(p -> Float.valueOf(p.chance)), (App)Codec.FLOAT.optionalFieldOf("chance_on_bred", (Object)Float.valueOf(-1.0f)).forGetter(p -> Float.valueOf(p.chanceOnBred)), (App)Codec.FLOAT.optionalFieldOf("luck_ratio", (Object)Float.valueOf(0.25f)).forGetter(p -> Float.valueOf(p.luckRatio)), (App)Codec.FLOAT.optionalFieldOf("luck_ratio_on_bred", (Object)Float.valueOf(-1.0f)).forGetter(p -> Float.valueOf(p.luckRatioOnBred))).apply((Applicative)builder, ChanceSourceTraitValueProvider::new));
    private final ISourceTraitValueProvider provider;
    private final float chance;
    private final float chanceOnBred;
    private final float luckRatio;
    private final float luckRatioOnBred;

    public ChanceSourceTraitValueProvider(ISourceTraitValueProvider provider, float chance, float chanceOnBred, float luckRatio, float luckRatioOnBred) {
        this.provider = provider;
        this.chance = chance;
        this.chanceOnBred = chanceOnBred;
        this.luckRatio = luckRatio;
        this.luckRatioOnBred = luckRatioOnBred;
    }

    @Override
    public ISourceTraitValue roll(SourceTraitRollContext context, Level level, BlockPos pos) {
        RandomSource random = context.random();
        if (random.nextFloat() < this.chance + this.getLuck(context.luck())) {
            return this.provider.roll(context, level, pos);
        }
        return null;
    }

    @Override
    @Nullable
    public ISourceTraitValue breed(SourceTraitRollContext context, @Nullable ISourceTraitValue value1, @Nullable ISourceTraitValue value2) {
        RandomSource random = context.random();
        int count = (value1 != null ? 1 : 0) + (value2 != null ? 1 : 0);
        if (count >= 2 || random.nextFloat() < this.getBreedChance(count) + this.getLuckOnBred(context.luck())) {
            return this.provider.breed(context, value1, value2);
        }
        return null;
    }

    private float getLuck(float luck) {
        return luck > 0.0f ? luck * this.luckRatio : 0.0f;
    }

    private float getLuckOnBred(float luck) {
        return luck > 0.0f ? luck * (this.luckRatioOnBred >= 0.0f ? this.luckRatioOnBred : this.luckRatio) : 0.0f;
    }

    private float getBreedChance(int count) {
        return (this.chanceOnBred >= 0.0f ? this.chanceOnBred : this.chance) + (float)count * 0.5f;
    }

    @NotNull
    public SourceTraitValueProviderType<ChanceSourceTraitValueProvider> getType() {
        return (SourceTraitValueProviderType)SourceTraitValueProviderTypes.CHANCE.get();
    }

    @Override
    public ISourceTraitValue load(Tag tag) {
        return this.provider.load(tag);
    }

    @Override
    public Tag save(ISourceTraitValue value) {
        return this.provider.save(value);
    }

    @Override
    public Codec<ISourceTraitValue> valueCodec() {
        return this.provider.valueCodec();
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec() {
        return this.provider.valueStreamCodec();
    }
}

