/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import sirttas.elementalcraft.api.source.trait.SourceTraitRollContext;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;

public class SourceTrait {
    public static final Codec<SourceTrait> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("order").forGetter(SourceTrait::getOrder), (App)ISourceTraitValueProvider.CODEC.fieldOf("value").forGetter(t -> t.valueProvider)).apply((Applicative)builder, SourceTrait::new));
    private ResourceLocation id;
    private final int order;
    private final ISourceTraitValueProvider valueProvider;

    public static Builder builder() {
        return new Builder();
    }

    public SourceTrait(int order, ISourceTraitValueProvider valueProvider) {
        this.order = order;
        this.valueProvider = valueProvider;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    @Nullable
    public ISourceTraitValue roll(ServerLevelAccessor level, BlockPos pos, float luck) {
        return this.valueProvider.roll(new SourceTraitRollContext(this, level.getRandom(), luck), (Level)level.getLevel(), pos);
    }

    @Nullable
    public ISourceTraitValue breed(RandomSource random, float luck, ISourceTraitValue value1, ISourceTraitValue value2) {
        return this.valueProvider.breed(new SourceTraitRollContext(this, random, luck), value1, value2);
    }

    @Nullable
    public ISourceTraitValue load(Tag tag) {
        return this.valueProvider.load(tag);
    }

    @Nullable
    public Tag save(ISourceTraitValue value) {
        return this.valueProvider.save(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof SourceTrait)) return false;
        SourceTrait trait = (SourceTrait)other;
        if (this.id == null) return false;
        if (!this.id.equals((Object)trait.id)) return false;
        return true;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public Codec<ISourceTraitValue> valueCodec() {
        return this.valueProvider.valueCodec();
    }

    public StreamCodec<RegistryFriendlyByteBuf, ISourceTraitValue> valueStreamCodec() {
        return this.valueProvider.valueStreamCodec();
    }

    public static class Builder {
        private static final AtomicInteger ORDER_INCREMENT = new AtomicInteger(0);
        public static final Encoder<Builder> ENCODER = CODEC.comap(builder -> new SourceTrait(builder.order, builder.valueProvider));
        private int order = ORDER_INCREMENT.getAndIncrement();
        private ISourceTraitValueProvider valueProvider;

        private Builder() {
        }

        public Builder order(int order) {
            this.order = order;
            if (order >= ORDER_INCREMENT.get()) {
                ORDER_INCREMENT.set(order + 1);
            }
            return this;
        }

        public Builder value(ISourceTraitValueProvider valueProvider) {
            this.valueProvider = valueProvider;
            return this;
        }
    }

    public static enum Type implements StringRepresentable
    {
        NONE("none"),
        CAPACITY("element_capacity"),
        EXTRACTION_SPEED("extraction_speed"),
        PRESERVATION("element_preservation"),
        BREEDING_COST("breeding_cost");

        public static final Codec<Type> CODEC;
        public static final Codec<Map<Type, Float>> VALUE_CODEC;
        private final String name;

        public static <T> Codec<Map<Type, T>> valueCodec(Codec<T> valueCodec) {
            return Codec.unboundedMap(CODEC, valueCodec);
        }

        private Type(String name) {
            this.name = name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            VALUE_CODEC = Type.valueCodec(Codec.FLOAT);
        }
    }
}

