/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.range;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.dpanvil.api.data.DataManagerCodecs;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.range.GrowthRatio;

public record Range(AABB box, boolean stitch, GrowthRatio growthRatio) {
    public static final Range DEFAULT = new Range(new AABB(BlockPos.ZERO), false, GrowthRatio.DEFAULT);
    public static final Holder<Range> DEFAULT_HOLDER = Holder.direct((Object)DEFAULT);
    public static final Codec<Range> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codecs.AABB.optionalFieldOf("box", (Object)new AABB(BlockPos.ZERO)).forGetter(Range::box), (App)Codec.BOOL.optionalFieldOf("stitch", (Object)false).forGetter(Range::stitch), (App)GrowthRatio.CODEC.optionalFieldOf("growth_ratio", (Object)GrowthRatio.DEFAULT).forGetter(Range::growthRatio)).apply((Applicative)builder, Range::new));
    public static final Codec<Holder<Range>> HOLDER_CODEC = DataManagerCodecs.holderCodec(ElementalCraftApi.RANGE_MANAGER_KEY, CODEC);

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder withParent(ResourceKey<Range> parent) {
        return Range.withParent(parent.location());
    }

    public static Builder withParent(ResourceLocation parent) {
        return new Builder(parent);
    }

    public AABB scaleBox(double multiplier) {
        AABB box = this.growthRatio.apply(this.box, multiplier);
        if (this.stitch) {
            box = Range.stitchAABB(box);
        }
        return box;
    }

    private static AABB stitchAABB(AABB source) {
        return new AABB(Math.floor(source.minX), Math.floor(source.minY), Math.floor(source.minZ), Math.ceil(source.maxX), Math.ceil(source.maxY), Math.ceil(source.maxZ));
    }

    public static class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.optionalFieldOf("parent").forGetter(b -> Optional.ofNullable(b.parent)), (App)Codecs.AABB.optionalFieldOf("box").forGetter(b -> Optional.ofNullable(b.box)), (App)Codec.BOOL.optionalFieldOf("stitch", (Object)false).forGetter(b -> b.stitch), (App)GrowthRatio.CODEC.optionalFieldOf("growth_ratio", (Object)GrowthRatio.DEFAULT).forGetter(b -> b.growthRatio)).apply((Applicative)builder, (a1, a2, a3, a4) -> {
            throw new UnsupportedOperationException("Builder deserialization is not supported.");
        }));
        private final ResourceLocation parent;
        private AABB box;
        private GrowthRatio growthRatio;
        private boolean stitch;

        private Builder(ResourceLocation parent) {
            this.parent = parent;
            this.box = null;
            this.growthRatio = GrowthRatio.DEFAULT;
            this.stitch = false;
        }

        public Builder box(double range) {
            return this.box(range, range);
        }

        public Builder boxTowards(Direction direction, double range) {
            GrowthRatio ratio = GrowthRatio.towards(direction);
            return this.box(ratio.west() * -range, ratio.down() * -range, ratio.north() * -range, ratio.east() * range + 1.0, ratio.up() * range + 1.0, ratio.south() * range + 1.0).growthRatio(ratio);
        }

        public Builder box(double horizontal, double vertical) {
            return this.box(horizontal, vertical, horizontal);
        }

        public Builder expendingUp(double horizontal, double vertical) {
            return this.box(-horizontal, 0.0, -horizontal, horizontal + 1.0, vertical, horizontal + 1.0);
        }

        public Builder expendingDown(double horizontal, double vertical) {
            return this.box(-horizontal, -vertical, -horizontal, horizontal + 1.0, 0.0, horizontal + 1.0);
        }

        public Builder box(double x, double y, double z) {
            return this.box(-x, -y, -z, x + 1.0, y + 1.0, z + 1.0);
        }

        public Builder box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return this.box(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
        }

        public Builder box(AABB aabb) {
            this.box = aabb;
            return this;
        }

        public Builder move(double x, double y, double z) {
            this.box = this.box.move(x, y, z);
            return this;
        }

        public Builder stitch() {
            this.stitch = true;
            return this;
        }

        public Builder growthRatio(GrowthRatio growthRatio) {
            this.growthRatio = growthRatio;
            return this;
        }

        public Builder fixedHeight() {
            return this.growthRatio(GrowthRatio.HORIZONTAL);
        }

        public Builder fixedWidth() {
            return this.growthRatio(GrowthRatio.VERTICAL);
        }
    }
}

