/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.range;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public record GrowthRatio(double west, double down, double north, double east, double up, double south) {
    public static final GrowthRatio DEFAULT = new GrowthRatio(1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
    public static final GrowthRatio NONE = new GrowthRatio(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final GrowthRatio HORIZONTAL = new GrowthRatio(1.0, 0.0, 1.0, 1.0, 0.0, 1.0);
    public static final GrowthRatio VERTICAL = new GrowthRatio(0.0, 1.0, 0.0, 0.0, 1.0, 0.0);
    public static final GrowthRatio ALIGNED_DOWN = new GrowthRatio(1.0, 2.0, 1.0, 1.0, 0.0, 1.0);
    public static final GrowthRatio ALIGNED_UP = new GrowthRatio(1.0, 0.0, 1.0, 1.0, 2.0, 1.0);
    public static final GrowthRatio ALIGNED_NORTH = new GrowthRatio(1.0, 1.0, 2.0, 1.0, 1.0, 0.0);
    public static final GrowthRatio ALIGNED_SOUTH = new GrowthRatio(1.0, 1.0, 0.0, 1.0, 1.0, 2.0);
    public static final GrowthRatio ALIGNED_WEST = new GrowthRatio(2.0, 1.0, 1.0, 0.0, 1.0, 1.0);
    public static final GrowthRatio ALIGNED_EAST = new GrowthRatio(0.0, 1.0, 1.0, 2.0, 1.0, 1.0);
    public static final Codec<GrowthRatio> CODEC = Codec.DOUBLE.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)6).map(doubles -> new GrowthRatio((Double)doubles.getFirst(), (Double)doubles.get(1), (Double)doubles.get(2), (Double)doubles.get(3), (Double)doubles.get(4), (Double)doubles.get(5))), growthRatio -> List.of(Double.valueOf(growthRatio.west), Double.valueOf(growthRatio.down), Double.valueOf(growthRatio.north), Double.valueOf(growthRatio.east), Double.valueOf(growthRatio.up), Double.valueOf(growthRatio.south)));

    public static GrowthRatio towards(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> ALIGNED_NORTH;
            case Direction.SOUTH -> ALIGNED_SOUTH;
            case Direction.WEST -> ALIGNED_WEST;
            case Direction.EAST -> ALIGNED_EAST;
            case Direction.UP -> ALIGNED_UP;
            case Direction.DOWN -> ALIGNED_DOWN;
        };
    }

    public AABB apply(AABB box, double multiplier) {
        double m = multiplier - 1.0;
        return new AABB(box.minX * (1.0 + this.west * m), box.minY * (1.0 + this.down * m), box.minZ * (1.0 + this.north * m), box.maxX * (1.0 + this.east * m), box.maxY * (1.0 + this.up * m), box.maxZ * (1.0 + this.south * m));
    }
}

