/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.pureore.factory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.api.pureore.PureOreException;

public interface IPureOreRecipeFactory<C extends RecipeInput, T extends Recipe<C>> {
    default public boolean filter(RecipeHolder<T> holder, ItemStack stack) {
        try {
            return ((Ingredient)holder.value().getIngredients().getFirst()).test(stack);
        }
        catch (Exception e) {
            throw new PureOreException(MessageFormat.format("Error while reading ingredients for recipe {0}. Please setup a custom filter for {1}", holder.id(), this), e);
        }
    }

    default public ItemStack getRecipeOutput(@Nonnull RegistryAccess registry, @Nonnull T recipe) {
        return recipe.getResultItem((HolderLookup.Provider)registry);
    }

    public T create(@Nonnull RegistryAccess var1, @Nonnull T var2, @Nonnull Ingredient var3);

    public List<RecipeHolder<T>> getRecipes(Collection<Holder<Item>> var1);

    public RecipeType<T> getRecipeType();
}

