/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.pureore.factory;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.api.pureore.factory.IPureOreRecipeFactory;

public abstract class AbstractPureOreRecipeFactory<C extends RecipeInput, T extends Recipe<C>>
implements IPureOreRecipeFactory<C, T> {
    private final RecipeType<T> recipeType;
    private final Collection<RecipeHolder<T>> recipes;

    protected AbstractPureOreRecipeFactory(@Nonnull RecipeManager recipeManager, @Nonnull RecipeType<T> recipeType) {
        this.recipeType = recipeType;
        this.recipes = recipeManager.byType(recipeType);
    }

    @Override
    public List<RecipeHolder<T>> getRecipes(Collection<Holder<Item>> ores) {
        List<ItemStack> stacks = ores.stream().map(ItemStack::new).toList();
        return this.recipes.stream().filter(h -> stacks.stream().anyMatch(s -> this.filter(h, (ItemStack)s))).toList();
    }

    @Override
    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public String toString() {
        ResourceLocation key = BuiltInRegistries.RECIPE_TYPE.getKey(this.recipeType);
        return key != null ? key.toString() : super.toString();
    }
}

