/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.infusion.tool;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.data.DataManagerCodecs;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.infusion.tool.effect.IToolInfusionEffect;

public class ToolInfusion
implements IElementTypeProvider {
    public static final ToolInfusion NONE = new ToolInfusion(ElementType.NONE, Collections.emptyList());
    public static final Codec<ToolInfusion> CODEC = RecordCodecBuilder.create(builder -> builder.group(ElementType.forGetter(ToolInfusion::getElementType), (App)IToolInfusionEffect.CODEC.listOf().fieldOf("effects").forGetter(ToolInfusion::getEffects)).apply((Applicative)builder, ToolInfusion::new));
    public static final Codec<Holder<ToolInfusion>> HOLDER_CODEC = DataManagerCodecs.holderCodec(ElementalCraftApi.TOOL_INFUSION_MANAGER_KEY, CODEC);
    private ResourceLocation id;
    private final ElementType elementType;
    private final List<IToolInfusionEffect> effects;

    public ToolInfusion(ElementType elementType, List<IToolInfusionEffect> effects) {
        this.elementType = elementType;
        this.effects = effects;
    }

    protected static <T extends ToolInfusion> Products.P1<RecordCodecBuilder.Mu<T>, ElementType> codec(RecordCodecBuilder.Instance<T> builder) {
        return builder.group(ElementType.forGetter(ToolInfusion::getElementType));
    }

    public List<Component> getTooltipInformation() {
        ArrayList tooltip = Lists.newArrayList();
        if (this.effects.size() == 1) {
            tooltip.add(Component.translatable((String)"tooltip.elementalcraft.infused.single", (Object[])new Object[]{this.elementType.getDisplayName(), this.effects.getFirst().getDescription()}).withStyle(ChatFormatting.YELLOW));
        } else {
            tooltip.add(Component.translatable((String)"tooltip.elementalcraft.infused", (Object[])new Object[]{this.elementType.getDisplayName()}).withStyle(ChatFormatting.YELLOW));
            this.effects.stream().map(e -> Component.literal((String)" ").append(e.getDescription()).withStyle(ChatFormatting.YELLOW)).forEach(tooltip::add);
        }
        return tooltip;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public List<IToolInfusionEffect> getEffects() {
        return this.effects;
    }
}

