/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.transfer.path;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;

public class SimpleElementTransferPathfinder {
    private ElementType type = ElementType.NONE;
    private IElementTransferPathNode source = null;
    private final Deque<NodeVisitor> nodes;
    private final List<Path> paths;
    private final List<IElementTransferer> visited;
    private final Level level;

    public SimpleElementTransferPathfinder(Level level) {
        this.level = level;
        this.nodes = new ArrayDeque<NodeVisitor>();
        this.paths = new LinkedList<Path>();
        this.visited = new ArrayList<IElementTransferer>();
    }

    public synchronized List<IElementTransferPath> findPaths(ElementType type, IElementTransferPathNode source, IElementTransferPathNode first) {
        if (type == ElementType.NONE) {
            return Collections.emptyList();
        }
        ProfilerFiller profiler = this.level.getProfiler();
        profiler.push("elementalcraft:simple_element_transfer_pathfinding");
        this.type = type;
        this.source = source;
        this.nodes.clear();
        this.paths.clear();
        this.visited.clear();
        this.nodes.push(new NodeVisitor(null, first));
        while (!this.nodes.isEmpty()) {
            this.nodes.pop().visit();
        }
        this.paths.sort(Comparator.comparing(Path::weight));
        profiler.pop();
        return List.copyOf(this.paths);
    }

    private class NodeVisitor {
        final NodeVisitor parent;
        final IElementTransferPathNode node;

        private NodeVisitor(NodeVisitor parent, IElementTransferPathNode node) {
            this.parent = parent;
            this.node = node;
        }

        public void visit() {
            IElementTransferer transferer;
            IElementStorage storage = this.node.getStorage();
            if (storage != null) {
                SimpleElementTransferPathfinder.this.paths.add(this.createPath(storage));
            }
            if ((transferer = this.node.getTransferer()) != null && !SimpleElementTransferPathfinder.this.visited.contains(transferer) && transferer.isValid()) {
                transferer.getConnectedNodes(SimpleElementTransferPathfinder.this.type).forEach(n -> SimpleElementTransferPathfinder.this.nodes.push(new NodeVisitor(this, (IElementTransferPathNode)n)));
                SimpleElementTransferPathfinder.this.visited.add(transferer);
            }
        }

        @NotNull
        private Path createPath(IElementStorage storage) {
            LinkedList<IElementTransferPathNode> list = new LinkedList<IElementTransferPathNode>();
            list.add(SimpleElementTransferPathfinder.this.source);
            NodeVisitor p = this.parent;
            while (p != null) {
                list.add(p.node);
                p = p.parent;
            }
            list.add(this.node);
            return new Path(SimpleElementTransferPathfinder.this.source.getStorage(), storage, SimpleElementTransferPathfinder.this.type, list);
        }
    }

    private record Path(IElementStorage source, IElementStorage target, ElementType type, List<IElementTransferPathNode> nodes, int weight) implements IElementTransferPath
    {
        public Path(IElementStorage source, IElementStorage target, ElementType type, List<IElementTransferPathNode> nodes) {
            this(source, target, type, List.copyOf(nodes), Path.getWeight(type, nodes));
        }

        private static int getWeight(ElementType type, List<IElementTransferPathNode> nodes) {
            AtomicInteger weight = new AtomicInteger(0);
            IElementTransferPathNode.forEachNodes(nodes, (node, prev, next) -> weight.addAndGet(node.getWeight(type, prev, next)));
            return weight.get();
        }

        @Override
        public boolean isValid() {
            return !this.nodes.isEmpty() && this.target != null && this.nodes.stream().allMatch(n -> {
                IElementTransferer transferer = n.getTransferer();
                return transferer == null || transferer.isValid();
            });
        }

        private int getRemainingTransferAmount() {
            return this.nodes.stream().map(IElementTransferPathNode::getTransferer).filter(Objects::nonNull).mapToInt(IElementTransferer::getRemainingTransferAmount).min().orElse(0);
        }

        @Override
        public void transfer() {
            if (!this.isValid()) {
                return;
            }
            IElementTransferPath.transfer(this.type, this.source.transferTo(this.target, this.type, this.getRemainingTransferAmount()), this.getNodes());
        }

        @Override
        public List<IElementTransferPathNode> getNodes() {
            return List.copyOf(this.nodes);
        }

        @Override
        @NotNull
        public ElementType getElementType() {
            return this.type;
        }
    }
}

