/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.transfer.path;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;

public interface IElementTransferPathNode {
    public BlockPos getPos();

    default public IElementTransferer getTransferer() {
        return null;
    }

    default public IElementStorage getStorage() {
        return null;
    }

    default public int getWeight(@Nonnull ElementType type, @Nullable IElementTransferPathNode prev, @Nullable IElementTransferPathNode next) {
        return 1;
    }

    public static void forEachNodes(List<IElementTransferPathNode> nodes, Consumer consumer) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            IElementTransferPathNode node = nodes.get(i);
            IElementTransferPathNode prev = i >= 1 ? nodes.get(i - 1) : null;
            IElementTransferPathNode next = i < size - 1 ? nodes.get(i + 1) : null;
            consumer.accept(node, prev, next);
        }
    }

    @FunctionalInterface
    public static interface Consumer {
        public void accept(@Nonnull IElementTransferPathNode var1, @Nullable IElementTransferPathNode var2, @Nullable IElementTransferPathNode var3);
    }
}

